package com.help.conditional;

import org.springframework.context.annotation.Conditional;

import java.lang.annotation.*;

/**
 * 判断某配置是否匹配特定值或不存在
 *
 * @author: YuBin-002726
 * @Date: 2019/9/12 9:40
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Documented
@Conditional(OnMatchOrEmptyCondition.class)
public @interface ConditionalOnMatchOrEmpty {

    /**
     * 配置项Key
     *
     * @return
     */
    String value();

    /**
     * 匹配的特定值
     *
     * @return
     */
    String[] havingValue();
}
