/*
 * Decompiled with CFR 0.152.
 */
package com.help.filter;

import com.help.common.HelpSleuthConfig;
import com.help.common.util.StringUtil;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.web.filter.OncePerRequestFilter;

public class TraceIdMDCFilter
extends OncePerRequestFilter {
    private HelpSleuthConfig config;

    public TraceIdMDCFilter(HelpSleuthConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filter) throws ServletException, IOException {
        try {
            String traceid = request.getHeader(this.config.getTraceIdHttpField());
            String parentId = request.getHeader(this.config.getParentSpanIdHttpField());
            if (StringUtil.isNotEmpty((String)parentId)) {
                MDC.put((String)this.config.getParentSpanIdMDCField(), (String)parentId);
            }
            String spanid = request.getHeader(this.config.getSpanIdHttpField());
            if (StringUtil.isEmpty((String)traceid)) {
                spanid = traceid = UUID.randomUUID().toString().replace("-", "").substring(0, 16);
            }
            if (StringUtil.isEmpty((String)spanid)) {
                spanid = UUID.randomUUID().toString().replace("-", "").substring(0, 16);
            }
            MDC.put((String)this.config.getTraceIdMDCField(), (String)traceid);
            MDC.put((String)this.config.getSpanIdMDCField(), (String)spanid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filter.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            MDC.remove((String)this.config.getTraceIdMDCField());
            MDC.remove((String)this.config.getParentSpanIdMDCField());
            MDC.remove((String)this.config.getSpanIdMDCField());
        }
    }
}

