package com.help.filter;

import com.help.common.HelpSleuthConfig;
import com.help.common.util.StringUtil;
import org.slf4j.MDC;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;

/**
 * 简易HTTP请求Token写入MDC过滤器
 *
 * @author JBF-YB
 */
public class TraceIdMDCFilter extends OncePerRequestFilter {

    private HelpSleuthConfig config;

    public TraceIdMDCFilter(HelpSleuthConfig config) {
        this.config = config;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filter) throws ServletException, IOException {
        try {
            String traceid = request.getHeader(config.getTraceIdHttpField());   //当前请求中包含的源系统traceId
            String parentId = request.getHeader(config.getParentSpanIdHttpField());

            if (StringUtil.isNotEmpty(parentId)) {
                MDC.put(config.getParentSpanIdMDCField(), parentId);
            }

            String spanid = request.getHeader(config.getSpanIdHttpField());

            if (StringUtil.isEmpty(traceid)) {
                //当前请求中不含有traceId,则认为请求由本系统开始 本系统生成traceId
                traceid = UUID.randomUUID().toString().replace("-", "").substring(0, 16);
                spanid = traceid;
            }
            if (StringUtil.isEmpty(spanid)) {
                spanid = UUID.randomUUID().toString().replace("-", "").substring(0, 16);
            }

            MDC.put(config.getTraceIdMDCField(), traceid);
            MDC.put(config.getSpanIdMDCField(), spanid);
        } catch (Exception e) {

        }

        try {
            filter.doFilter(request, response);
        } finally {
            MDC.remove(config.getTraceIdMDCField());
            MDC.remove(config.getParentSpanIdMDCField());
            MDC.remove(config.getSpanIdMDCField());
        }
    }

}
