/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.ITokenContext;
import com.help.session.HelpSessionConfig;
import com.helpframework.HelpRedissonHttpSessionConfig;
import com.helpframework.HelpRedissonSessionRepository;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.util.StringUtils;

@AutoConfigureAfter(name={"com.help.autoconfig.HelpRedissonTokenAutoConfiguration"})
@ConditionalOnClass(value={RedissonClient.class})
@ConditionalOnBean(value={RedissonClient.class})
@ConditionalOnMissingBean(value={HelpRedissonHttpSessionConfig.class, ITokenContext.class})
public class HelpRedissonHttpSessionAutoConfiguration
extends SpringHttpSessionConfiguration {
    private static Logger logger = LoggerFactory.getLogger(HelpRedissonHttpSessionConfig.class);
    @Value(value="${spring.application.name:HELP}")
    private String appName;

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="help.session")
    public HelpSessionConfig helpSessionConfig() {
        return new HelpSessionConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={RedissonClient.class, HelpSessionConfig.class})
    public HelpRedissonSessionRepository helpRedissonSessionRepository(RedissonClient redissonClient, ApplicationEventPublisher eventPublisher, HelpSessionConfig helpSessionConfig) {
        HelpRedissonSessionRepository repository = new HelpRedissonSessionRepository(redissonClient, eventPublisher, this.appName);
        if (StringUtils.hasText((String)helpSessionConfig.getKeyPrefix())) {
            repository.setKeyPrefix(helpSessionConfig.getKeyPrefix());
        }
        repository.setDefaultMaxInactiveInterval(helpSessionConfig.getTimeout());
        logger.info("\u68c0\u6d4b\u5230Redisson\u8fde\u63a5,\u81ea\u52a8\u914d\u7f6e[\u5206\u5e03\u5f0fSession\u7ba1\u7406\u5668],Session\u8d85\u65f6\u65f6\u95f4:[" + helpSessionConfig.getTimeout() + "]\u79d2");
        return repository;
    }
}

