/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.AbstractLoginToken;
import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.OperationLog;
import com.help.common.InvocationResult;
import com.help.common.exception.UnifyException;
import com.help.common.util.Convert;
import com.help.common.util.SignUtil;
import com.help.common.util.StringUtil;
import com.help.constant.OperationType;
import com.help.constraint.IHelpOAuthClientProxy;
import com.help.constraint.IHelpSystemComponent;
import com.help.oauth.IUserOAuthAnalysis;
import com.help.oauth.lanxin.ILanXinOAuthDecryptor;
import com.help.service.ILoginService;
import com.helpframework.config.HelpCrcbOAuthConfig;
import com.helpframework.config.HelpLanXinOAuthConfig;
import com.helpframework.config.HelpLocalOAuthConfig;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/oauth"})
public class OAuthController
implements IHelpSystemComponent {
    @Autowired
    ILoginService iLoginService;
    @Autowired(required=false)
    HelpCrcbOAuthConfig helpCrcbOAuthConfig;
    @Autowired(required=false)
    HelpLocalOAuthConfig helpLocalOAuthConfig;
    @Autowired(required=false)
    HelpLanXinOAuthConfig helpLanXinOAuthConfig;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;
    @Autowired(required=false)
    IHelpOAuthClientProxy iHelpOAuthClientProxy;
    @Autowired
    IUserOAuthAnalysis iUserOAuthAnalysis;
    @Autowired(required=false)
    ILanXinOAuthDecryptor iLanXinOAuthDecryptor;

    @PostMapping(value={"/callback-async.do"})
    @ResponseBody
    @OperationLog(value="\u7528\u6237\u5355\u70b9\u767b\u5f55", type=OperationType.BUSINESS)
    public InvocationResult loginAsync(HttpServletRequest request, String userId, String clientId, String signTime, String sign, String userid, String phone) {
        Date dt;
        String key;
        String analysisdId = null;
        if (StringUtil.isNotEmptyAll((String[])new String[]{userId, clientId, signTime, sign}) && this.helpLocalOAuthConfig != null && this.helpLocalOAuthConfig.getClients() != null && StringUtil.isNotEmpty((String)(key = this.helpLocalOAuthConfig.getClients().get(clientId))) && ((dt = Convert.toDate((String)signTime, (String)"yyyyMMddHHmmss")).getTime() - System.currentTimeMillis()) * (dt.getTime() - System.currentTimeMillis()) <= 360000000000L) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", userId);
            map.put("clientId", clientId);
            map.put("signTime", signTime);
            map.put("sign", sign);
            boolean valid = SignUtil.validate(map, (String)key);
            if (valid) {
                analysisdId = this.iUserOAuthAnalysis.analysis(userId, null);
            }
        }
        if (StringUtil.isEmpty(analysisdId) && this.iLanXinOAuthDecryptor != null && StringUtil.isNotEmptyAny((String[])new String[]{userid, phone})) {
            if (StringUtil.isNotEmpty((String)userid)) {
                userid = this.iLanXinOAuthDecryptor.decrypt(userid);
            }
            if (StringUtil.isNotEmpty((String)phone)) {
                phone = this.iLanXinOAuthDecryptor.decrypt(phone);
            }
            analysisdId = this.iUserOAuthAnalysis.analysis(userid, phone);
        }
        if (StringUtil.isEmpty(analysisdId) && this.iHelpOAuthClientProxy != null) {
            analysisdId = this.iHelpOAuthClientProxy.analysisUser(request);
        }
        if (StringUtil.isEmpty(analysisdId)) {
            return new InvocationResult();
        }
        LoginInfo old = (LoginInfo)this.iTokenContext.getCurrentToken();
        if (old != null && old.getUserId().equalsIgnoreCase(analysisdId)) {
            return new InvocationResult((Object)old.getToken());
        }
        if (old != null) {
            this.iTokenContext.removeToken();
        }
        try {
            LoginInfo loginInfo = this.iLoginService.getToken(analysisdId);
            this.iTokenContext.saveToken((AbstractLoginToken)loginInfo);
            return new InvocationResult((Object)loginInfo.getToken());
        }
        catch (UnifyException e) {
            return new InvocationResult();
        }
    }

    public String getName() {
        if (this.helpCrcbOAuthConfig == null) {
            return "\u5458\u5de5\u7cfb\u7edf\u5355\u70b9\u767b\u5f55\u670d\u52a1(\u672c\u5730\u3001\u84dd\u4fe1)";
        }
        return "\u5458\u5de5\u7cfb\u7edf\u5355\u70b9\u767b\u5f55\u670d\u52a1(\u672c\u5730\u3001\u84dd\u4fe1\u3001\u5458\u5de5\u4e2d\u5fc3-" + (this.helpCrcbOAuthConfig.isSimpleMatch() ? "\u7b80\u5355\u5339\u914d\u6a21\u5f0f" : "\u624b\u52a8\u7ed1\u5b9a\u6a21\u5f0f") + ")";
    }
}

