/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework;

import com.help.autoconfig.ESBClientAutoConfiguration;
import com.help.esb.client.ESBSocketClient;
import com.help.oauth.lanxin.ESBClientLanXinOAuthDecryptor;
import com.help.oauth.lanxin.ILanXinOAuthDecryptor;
import com.helpframework.HelpOAuthLanXinAESAutoConfiguration;
import com.helpframework.config.HelpLanXinOAuthConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={ESBSocketClient.class})
@AutoConfigureAfter(value={HelpOAuthLanXinAESAutoConfiguration.class, ESBClientAutoConfiguration.class})
@ConditionalOnBean(value={HelpLanXinOAuthConfig.class})
@ConditionalOnMissingBean(value={ILanXinOAuthDecryptor.class})
@ConditionalOnProperty(prefix="help.oauth.lanxin", name={"app-id"})
public class HelpOAuthLanXinESBClientAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpOAuthLanXinESBClientAutoConfiguration.class);

    @Bean(value={"esbClientLanXinOAuthDecryptorSpecial"})
    @ConditionalOnProperty(prefix="help.oauth.lanxin", name={"esb-ip", "esb-port"})
    public ESBClientLanXinOAuthDecryptor esbClientLanXinOAuthDecryptor(HelpLanXinOAuthConfig helpLanXinOAuthConfig) {
        return new ESBClientLanXinOAuthDecryptor(new ESBSocketClient(helpLanXinOAuthConfig.getEsbIp(), helpLanXinOAuthConfig.getEsbPort()), helpLanXinOAuthConfig.getAppId());
    }

    @Bean
    @ConditionalOnBean(value={ESBSocketClient.class})
    @ConditionalOnMissingBean(name={"esbClientLanXinOAuthDecryptorSpecial"})
    public ESBClientLanXinOAuthDecryptor esbClientLanXinOAuthDecryptor(ESBSocketClient defaultClient, HelpLanXinOAuthConfig helpLanXinOAuthConfig) {
        this.logger.info("\u672a\u627e\u5230[help.oauth.lanxin.esb-ip]\u4e0e[help.oauth.lanxin.esb-port]\u914d\u7f6e\u9879,\u84dd\u4fe1OAuth\u5c06\u91c7\u7528\u9ed8\u8ba4ESB\u8fde\u63a5\u7ec4\u4ef6");
        return new ESBClientLanXinOAuthDecryptor(defaultClient, helpLanXinOAuthConfig.getAppId());
    }
}

