/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework;

import com.help.CrcbOAuthClient;
import com.help.CrcbOAuthConfig;
import com.help.common.util.StringUtil;
import com.help.constraint.IHelpOAuthClientProxy;
import com.help.domain.UserInfo;
import com.help.oauth.IUserOAuthAnalysis;
import com.help.service.ILoginService;
import com.help.storage.IUserStorage;
import com.helpframework.HelpCrcbOAuthClientProxy;
import com.helpframework.config.HelpCrcbOAuthConfig;
import com.helpframework.config.HelpLanXinOAuthConfig;
import com.helpframework.config.HelpLocalOAuthConfig;
import com.helpframework.controller.OAuthController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={IHelpOAuthClientProxy.class, CrcbOAuthConfig.class, ILoginService.class})
public class HelpOAuthCrcbAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpOAuthCrcbAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="help.oauth.crcb", name={"server-url", "client-id", "secret"})
    public HelpCrcbOAuthConfig helpCrcbOAuthConfig() {
        return new HelpCrcbOAuthConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public HelpLocalOAuthConfig helpLocalOAuthConfig() {
        return new HelpLocalOAuthConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public HelpLanXinOAuthConfig helpLanXinOAuthConfig() {
        return new HelpLanXinOAuthConfig();
    }

    @Bean
    @ConditionalOnBean(value={IUserStorage.class})
    @ConditionalOnMissingBean(value={IUserOAuthAnalysis.class})
    public IUserOAuthAnalysis iUserOAuthAnalysis(IUserStorage iUserStorage) {
        return (jobNumber, phone) -> {
            UserInfo info;
            if (StringUtil.isNotEmpty((String)jobNumber) && (info = iUserStorage.getByJobNumber(jobNumber)) != null) {
                return info.getUserNo();
            }
            if (StringUtil.isNotEmpty((String)phone) && (info = iUserStorage.getByPhone(phone)) != null) {
                return info.getUserNo();
            }
            return null;
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={CrcbOAuthConfig.class})
    public CrcbOAuthClient crcbOAuthClient(CrcbOAuthConfig config) {
        this.logger.info("\u68c0\u6d4b\u5230HELP\u5e73\u53f0\u540e\u7ba1\u7aef\u73af\u5883,\u5e38\u719f\u94f6\u884c\u7edf\u4e00\u5458\u5de5\u4e2d\u5fc3OAuth\u5ba2\u6237\u7aefSDK,\u81ea\u52a8\u914d\u7f6e[HELP\u5e73\u53f0\u540e\u7ba1\u7aef\u5e38\u719f\u519c\u5546\u94f6\u884cOAuth\u63a5\u5165\u7ec4\u4ef6],\u670d\u52a1\u5668:[" + config.getServerUrl() + "],\u5ba2\u6237\u7aefID:[" + config.getClientId() + "]");
        return new CrcbOAuthClient(config);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpCrcbOAuthConfig.class, CrcbOAuthClient.class, IUserOAuthAnalysis.class})
    public HelpCrcbOAuthClientProxy crcbOAuthClientProxy(CrcbOAuthClient client, HelpCrcbOAuthConfig config, IUserOAuthAnalysis iUserOAuthAnalysis) {
        return new HelpCrcbOAuthClientProxy(client, config, iUserOAuthAnalysis);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ILoginService.class})
    public OAuthController oAuthController() {
        return new OAuthController();
    }
}

