/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework;

import com.help.CrcbOAuthClient;
import com.help.common.util.StringUtil;
import com.help.constraint.IHelpOAuthClientProxy;
import com.help.domain.OAuthUser;
import com.help.oauth.IUserOAuthAnalysis;
import com.helpframework.config.HelpCrcbOAuthConfig;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpCrcbOAuthClientProxy
implements IHelpOAuthClientProxy {
    Logger logger = LoggerFactory.getLogger(HelpCrcbOAuthClientProxy.class);
    CrcbOAuthClient client;
    HelpCrcbOAuthConfig config;
    IUserOAuthAnalysis iUserOAuthAnalysis;

    public HelpCrcbOAuthClientProxy(CrcbOAuthClient client, HelpCrcbOAuthConfig config, IUserOAuthAnalysis iUserOAuthAnalysis) {
        this.client = client;
        this.config = config;
        this.iUserOAuthAnalysis = iUserOAuthAnalysis;
    }

    public String oauthUser(String userId) {
        if (this.config.isOffline()) {
            return null;
        }
        try {
            OAuthUser user = this.client.bindInfo(userId);
            if (user != null) {
                return user.getUserId();
            }
            if (this.config.isSimpleMatch()) {
                return userId;
            }
            return null;
        }
        catch (Exception e) {
            this.logger.warn("OAuth\u7cfb\u7edf[" + this.config.getServerUrl() + "]\u8fde\u63a5\u5931\u8d25");
            return null;
        }
    }

    public String systemName() {
        return "\u7edf\u4e00\u5458\u5de5\u7cfb\u7edf";
    }

    public String indexUrl() {
        return this.config.getServerUrl();
    }

    public String loginUrl(String redirectUrl) {
        return this.client.oAuthUrl(redirectUrl);
    }

    public String bindUrl(String userId, String userName) {
        return this.client.bindUrl(userId, userName);
    }

    public String bindUrl(String userId, String userName, String redirectUrl) {
        return this.client.bindUrl(userId, userName, redirectUrl);
    }

    public String analysisUser(HttpServletRequest request) {
        OAuthUser oauthUser = null;
        if (this.config.isOffline() && StringUtil.isNotEmpty((String)request.getParameter("encrypt"))) {
            try {
                oauthUser = this.client.decryptUser(request.getParameter("encrypt"));
            }
            catch (Exception e) {
                this.logger.warn("\u5458\u5de5\u7cfb\u7edf\u7528\u6237\u4fe1\u606f\u89e3\u5bc6\u5931\u8d25:" + e);
                oauthUser = null;
            }
        } else if (StringUtil.isNotEmpty((String)request.getParameter("code"))) {
            oauthUser = this.client.codeToUser(request.getParameter("code"));
        }
        if (oauthUser == null) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)oauthUser.getClientUserId())) {
            return oauthUser.getClientUserId();
        }
        if (this.config.isSimpleMatch()) {
            return oauthUser.getUserId();
        }
        return this.iUserOAuthAnalysis.analysis(oauthUser.getUserId(), null);
    }
}

