/*
 * Decompiled with CFR 0.152.
 */
package com.help.oauth.lanxin;

import com.help.common.exception.ESBException;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.Convert;
import com.help.common.util.StringUtil;
import com.help.constraint.IHelpSystemComponent;
import com.help.esb.ESBResponseHelper;
import com.help.esb.SocketParam;
import com.help.esb.client.ESBSocketClient;
import com.help.oauth.lanxin.ILanXinOAuthDecryptor;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESBClientLanXinOAuthDecryptor
implements ILanXinOAuthDecryptor,
IHelpSystemComponent {
    private Logger logger = LoggerFactory.getLogger(ESBClientLanXinOAuthDecryptor.class);
    private ESBSocketClient esbSocketClient;
    private String appId;

    public ESBClientLanXinOAuthDecryptor(ESBSocketClient esbSocketClient, String appId) {
        this.esbSocketClient = esbSocketClient;
        this.appId = appId;
    }

    @Override
    public String decrypt(String content) {
        SocketParam request = new SocketParam("service");
        SocketParam sysHead = request.appendChild("SYS_HEAD");
        sysHead.appendChild("ServiceCode", "50012000033");
        sysHead.appendChild("ServiceScene", "01");
        sysHead.appendChild("TranDate", Convert.toString((Date)new Date(), (String)"yyyyMMdd"));
        sysHead.appendChild("TranTime", Convert.toString((Date)new Date(), (String)"HHmmss"));
        sysHead.appendChild("FilFlg", "0");
        SocketParam body = request.appendChild("BODY");
        body.appendChild("EryptUsrID", content);
        body.appendChild("AppId", this.appId);
        body.appendChild("TxnCd", "lx1001");
        SocketParam response = this.esbSocketClient.sendRequest(request);
        try {
            ESBResponseHelper.validate((SocketParam)response);
            String userId = response.getChild("BODY").getChildText("UsrID");
            if (StringUtil.isEmpty((String)userId)) {
                return null;
            }
            return userId;
        }
        catch (ESBException e) {
            this.logger.warn("\u84dd\u4fe1\u7528\u6237[{}]\u901a\u8fc7ESB\u89e3\u6790\u5931\u8d25", (Object)content, (Object)e);
            throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u84dd\u4fe1\u7528\u6237\u89e3\u6790\u5931\u8d25");
        }
    }

    public String getName() {
        return "\u84dd\u4fe1\u5355\u70b9\u767b\u5f55\u670d\u52a1-ESB\u89e3\u6790(" + this.appId + ")";
    }
}

