/*
 * Decompiled with CFR 0.152.
 */
package com.help.oauth;

import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SignUtil {
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = threadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat("yyyyMMddHHmmss", Locale.CHINA);
            threadLocal.set(df);
        }
        return df;
    }

    public static boolean validate(Map<String, String> map, String token) {
        String clientId = map.get("clientId");
        String timeStr = map.get("signTime");
        String sign = map.get("sign");
        if (SignUtil.isEmpty(clientId) || SignUtil.isEmpty(timeStr) || SignUtil.isEmpty(sign)) {
            return false;
        }
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : map.entrySet()) {
            if ("sign".equals(kv.getKey())) continue;
            tmp.put(kv.getKey().toLowerCase(), kv.getValue());
        }
        try {
            Date time = SignUtil.getDateFormat().parse(timeStr);
            return sign.equalsIgnoreCase(SignUtil.sign(tmp, clientId, token, time));
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static String sign(Map<String, String> map, String clientId, String key, Date date) {
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : map.entrySet()) {
            if ("sign".equals(kv.getKey()) || !SignUtil.isNotEmpty(kv.getValue())) continue;
            tmp.put(kv.getKey().toLowerCase(), kv.getValue().trim());
        }
        tmp.put("clientid", clientId);
        tmp.put("signtime", SignUtil.getDateFormat().format(date));
        Object[] keys = tmp.keySet().toArray(new String[tmp.size()]);
        Arrays.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (Object k : keys) {
            String value = (String)tmp.get(k);
            sb.append("&");
            sb.append(((String)k).toLowerCase());
            sb.append("=");
            sb.append(value);
        }
        sb.append("&");
        sb.append(key);
        return SignUtil.toSHA1(sb.substring(1)).toUpperCase();
    }

    public static String toSHA1(String str) {
        return SignUtil.sha(str, "SHA-1", "utf-8");
    }

    private static String sha(String decript, String type, String encoding) {
        try {
            MessageDigest digest = MessageDigest.getInstance(type);
            digest.update(decript.getBytes(encoding));
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u8f6cSHA\u5931\u8d25");
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !SignUtil.isEmpty(str);
    }

    public static void main(String[] args) {
        String userId = "002726";
        String clientId = "kfxt";
        String key = "123456";
        Date dt = new Date();
        String time = new SimpleDateFormat("yyyyMMddHHmmss").format(dt);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        String sign = SignUtil.sign(param, clientId, key, dt);
        String url = "http://170.120.130.54:8081/ui/#/oauth/callback?userId=" + userId + "&clientId=" + clientId + "&signTime=" + time + "&sign=" + sign + "&redirect=%2fcomplaintManage%2fcomplaintOrderInfo%3ftitle%3d%25E6%2596%25B0%25E5%25A2%259E%26serno%3d%26operateFlag%3dadd";
        System.out.println(url);
    }
}

