/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework;

import com.help.config.HelpManageConfig;
import com.help.constraint.ISearchable;
import com.help.service.IDicService;
import com.help.validator.InDicFieldValidator;
import com.help.web.TranscodeBuilder;
import com.help.web.aop.GlobalAuthorizationCheckAspect;
import com.help.web.aop.HelpOperationLogAspect;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@EnableAspectJAutoProxy(exposeProxy=true)
public class HelpManageConfigAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="help.manage")
    public HelpManageConfig helpManageConfig() {
        return new HelpManageConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public GlobalAuthorizationCheckAspect globalAuthorizationCheckAspect() {
        return new GlobalAuthorizationCheckAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    public InDicFieldValidator inDicFieldValidator() {
        return new InDicFieldValidator();
    }

    @Bean
    @ConditionalOnExpression(value="!'${help.manage.operation-log-storage:}'.equalsIgnoreCase('')")
    public HelpOperationLogAspect helpOperationLogAspect() {
        return new HelpOperationLogAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    public TranscodeBuilder transcodeBuilder(@Autowired(required=false) IDicService dictionaryService, @Autowired(required=false) List<ISearchable> iSearchables) {
        return new TranscodeBuilder(dictionaryService, iSearchables);
    }
}

