/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework;

import com.help.cache.HelpRedissonSpringCacheManager;
import com.help.config.HelpCacheConfig;
import com.help.constraint.IHelpSystemComponent;
import com.helpframework.HelpCacheBaseAutoConfiguration;
import com.helpframework.HelpCacheConcurrentAutoConfiguration;
import java.util.HashMap;
import java.util.List;
import org.redisson.api.RedissonClient;
import org.redisson.spring.cache.CacheConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={RedissonClient.class})
@ConditionalOnBean(value={RedissonClient.class})
@AutoConfigureBefore(value={HelpCacheConcurrentAutoConfiguration.class})
@EnableCaching
public class HelpCacheRedissonAutoConfiguration
extends HelpCacheBaseAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HelpCacheRedissonAutoConfiguration.class);
    @Value(value="${spring.application.name:HELP}")
    private String appName;
    @Autowired
    RedissonClient redissonClient;
    private CacheManager cacheManager;
    @Autowired(required=false)
    List<HelpCacheConfig> helpCacheConfigList;

    @Bean
    public CacheManager cacheManager() {
        if (this.cacheManager == null) {
            HashMap<String, CacheConfig> config = new HashMap<String, CacheConfig>();
            if (this.helpCacheConfigList != null) {
                for (HelpCacheConfig c : this.helpCacheConfigList) {
                    config.put(c.getName(), new CacheConfig(c.getTtl(), c.getMaxIdleTime()));
                }
            }
            this.cacheManager = new HelpRedissonSpringCacheManager(this.appName + "_cache_", this.redissonClient, config);
            logger.info("\u68c0\u6d4b\u5230Redisson\u8fde\u63a5,\u81ea\u52a8\u914d\u7f6e[Redisson\u5206\u5e03\u5f0f\u7f13\u5b58\u7ba1\u7406\u5668]");
        }
        return this.cacheManager;
    }

    @Bean
    public IHelpSystemComponent iHelpSystemComponentRedissonCache() {
        return () -> "\u7f13\u5b58\u670d\u52a1-\u5206\u5e03\u5f0f-Redisson";
    }
}

