/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework;

import com.help.config.HelpCacheConfig;
import com.help.constraint.IHelpSystemComponent;
import com.helpframework.HelpCacheBaseAutoConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={CacheManager.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@EnableCaching
public class HelpCacheConcurrentAutoConfiguration
extends HelpCacheBaseAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HelpCacheConcurrentAutoConfiguration.class);
    @Value(value="${spring.application.name:HELP}")
    private String appName;
    private ConcurrentMapCacheManager cacheManager;
    @Autowired(required=false)
    List<HelpCacheConfig> helpCacheConfigList;

    @Bean
    public CacheManager cacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new ConcurrentMapCacheManager();
            if (this.helpCacheConfigList != null) {
                this.cacheManager.setCacheNames((Collection)this.helpCacheConfigList.stream().map(p -> p.getName()).collect(Collectors.toList()));
            } else {
                this.cacheManager.setCacheNames(new ArrayList());
            }
            logger.info("\u672a\u68c0\u6d4b\u5230Redisson\u8fde\u63a5,\u81ea\u52a8\u914d\u7f6e[\u672c\u5730\u7f13\u5b58\u7ba1\u7406\u5668]");
        }
        return this.cacheManager;
    }

    @Bean
    public IHelpSystemComponent iHelpSystemComponentLocalCache() {
        return () -> "\u7f13\u5b58\u670d\u52a1-\u672c\u5730\u5185\u5b58";
    }
}

