package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.ExampleConvert;
import com.help.common.InvocationResult;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.domain.POperationLog;
import com.help.domain.POperationLogExample;
import com.help.service.POperationLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 操作日志控制器
 *
 * @author: Help-Generator Template By YuBin
 * @Date: 2019/9/29 14:06
 */
@RestController
@UnifyAuthorization(module = "operation_log", moduleName = "系统操作日志", system = CommonConstant.YES)
@RequestMapping("/pOperationLog")
public class POperationLogController {

    @Autowired
    private POperationLogService pOperationLogService;

    @UnifyAuthorization(op = "clean", opName = "清空")
    @PostMapping(value = "/clean.do")
    @OperationLog(value = "清空操作日志", type = OperationType.SYSTEM)
    public InvocationResult delete() {
        pOperationLogService.clean();
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DETAIL)
    @PostMapping(value = "/detail.do")
    public InvocationResult detail(@ParamValid Long id) {
        POperationLog detail = pOperationLogService.get(id);
        return new InvocationResult(detail);
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/listByPage.do")
    public InvocationResult listByPage(UnifyPageInfo page, POperationLog pOperationLog) {
        POperationLogExample example = ExampleConvert.toEqualsExample(pOperationLog, POperationLogExample.class);
        example.setOrderByClause("gmt_create desc");

        UnifyPageData<POperationLog> list = pOperationLogService.list(page, example);
        return new InvocationResult(list);
    }
}