package com.helpframework.controller;

import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.constant.PermissionConstant;
import com.help.domain.LegalInfo;
import com.help.storage.ILegalStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/legal")
@UnifyAuthorization(module = PermissionConstant.CONFIG_LEGAL_MENU, moduleName = "法人管理", system = CommonConstant.YES)
public class LegalController {

    @Autowired
    private ILegalStorage iLegalStorage;

    @PostMapping(value = "/detail.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DETAIL)
    public InvocationResult<LegalInfo> detail(@ParamValid String legalNo) {
        return new InvocationResult(iLegalStorage.get(legalNo));
    }

    @RequestMapping(value = "/list.do", method = RequestMethod.POST)
    public InvocationResult<List<LegalInfo>> list() {
        return new InvocationResult(iLegalStorage.list());
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/listByPage.do")
    public InvocationResult<UnifyPageData<LegalInfo>> listByPage(UnifyPageInfo page, @RequestParam(required = false) String name) {
        UnifyPageData<LegalInfo> list = iLegalStorage.searchByPage(name, page);
        return new InvocationResult(list);
    }

}
