package com.helpframework.controller;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.exception.UnifyErrorCode;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.domain.UserInfo;
import com.help.storage.editable.IEditableUserStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * @author: YuBin-002726
 * @Date: 2019/1/30 9:01
 */
@UnifyAuthorization(module = PermissionConstant.CONFIG_USER_MENU, moduleName = "用户管理", system = CommonConstant.YES)
@RestController
@RequestMapping("/user")
public class EditUserController {
    @Autowired
    private IEditableUserStorage iUserStorage;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;

    @PostMapping(value = "/create.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_ADD)
    @OperationLog(value = "新增用户[{0}-{1}]", spel = {"#user.userNo", "#user.userName"}, type = OperationType.BASE)
    public InvocationResult create(@ParamValid UserInfo user) {
        user.setCreateTime(new Date(System.currentTimeMillis()));
        user.setCreater(iTokenContext.getCurrentToken().getUserId());
        user.setPassword("123456");
        iUserStorage.add(user);
        return new InvocationResult("123456");
    }

    @PostMapping(value = "/update.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_UPDATE)
    @OperationLog(value = "修改用户[{0}]", spel = {"#user.userNo"}, type = OperationType.BASE)
    public InvocationResult update(@ParamValid UserInfo user) {
        iUserStorage.edit(user);
        return InvocationResult.SUCCESS;
    }

    //重设密码
    @PostMapping(value = "/reset.do")
    @UnifyAuthorization(op = "reset", opName = "重设密码")
    @OperationLog(value = "重置用户[{0}]密码", spel = "#userNo", type = OperationType.BASE)
    public InvocationResult reset(@ParamValid String userNo) {
        iUserStorage.resetPwd(userNo, "123456");

        return new InvocationResult("123456");
    }

    @PostMapping(value = "/delete.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DELETE)
    @OperationLog(value = "删除用户[{0}]", spel = "#userNo", type = OperationType.BASE)
    public InvocationResult delete(@ParamValid String userNo) {
        if (iTokenContext.getCurrentToken().getUserId().equalsIgnoreCase(userNo)) {
            return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD, "您不可以删除自己");
        }
        iUserStorage.delete(userNo);
        return InvocationResult.SUCCESS;
    }


}
