package com.helpframework.controller;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.util.StringUtil;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.storage.editable.IEditableUserAffiliationStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: YuBin-002726
 * @Date: 2019/1/30 9:01
 */
@UnifyAuthorization(module = PermissionConstant.CONFIG_USER_MENU, moduleName = "用户管理", system = CommonConstant.YES)
@RestController
@RequestMapping("/user")
public class EditUserAffiliationController {

    @Autowired
    private IEditableUserAffiliationStorage iEditableUserAffiliationStorage;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;

    @UnifyAuthorization(op = "update_role", opName = "分配角色")
    @PostMapping(value = "/joinToRole.do")
    @OperationLog(value = "为用户[{0}]分配角色[{1}]", spel = {"#userNo", "#roleNo"}, type = OperationType.BASE)
    public InvocationResult joinToRole(String userNo, String roleNo, @RequestParam(required = false) String deptNo, @RequestParam(required = false) String orgNo) {
        if (StringUtil.isEmpty(deptNo) && StringUtil.isEmpty(orgNo)) {
            iEditableUserAffiliationStorage.addUserToRole(userNo, roleNo);
        } else {
            if (StringUtil.isNotEmpty(deptNo)) {
                iEditableUserAffiliationStorage.addUserToDeptRole(userNo, deptNo, roleNo);
            }
            if (StringUtil.isNotEmpty(orgNo)) {
                iEditableUserAffiliationStorage.addUserToOrgRole(userNo, orgNo, roleNo);
            }
        }
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = "update_role", opName = "用户角色配置")
    @PostMapping(value = "/leaveFromRole.do")
    @OperationLog(value = "移除用户[{0}]的角色[{1}]", spel = {"#userNo", "#roleNo"}, type = OperationType.BASE)
    public InvocationResult leaveFromDept(String userNo, String roleNo, @RequestParam(required = false) String deptNo, @RequestParam(required = false) String orgNo) {
        if (StringUtil.isEmpty(deptNo) && StringUtil.isEmpty(orgNo)) {
            iEditableUserAffiliationStorage.removeUserFromRole(userNo, roleNo);
        } else {
            if (StringUtil.isNotEmpty(deptNo)) {
                iEditableUserAffiliationStorage.removeUserFromDeptRole(userNo, deptNo, roleNo);
            }
            if (StringUtil.isNotEmpty(orgNo)) {
                iEditableUserAffiliationStorage.removeUserFromOrgRole(userNo, orgNo, roleNo);
            }
        }
        return InvocationResult.SUCCESS;
    }
}
