package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.domain.TreeDicItem;
import com.help.storage.editable.IEditableTreeDicStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统树形字典表 控制器
 * 对应数据库表 P_TREE_DIC
 *
 * @Generator help.mybatis.generator.plugins.HelpPlantformControllerPlugin
 */
@RestController
@UnifyAuthorization(module = PermissionConstant.CONFIG_TREEDIC_MENU, moduleName = "树形字典配置", system = CommonConstant.YES)
@RequestMapping("/treedic")
public class EditTreeDicController {
    @Autowired
    private IEditableTreeDicStorage iTreeDicStorage;

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_ADD)
    @PostMapping(value = "/create.do")
    @OperationLog(value = "创建树形字典[{0}-{1}-{2}]", spel = {"dic.dicType", "#dic.code", "#dic.text"}, type = OperationType.BASE)
    public InvocationResult create(@ParamValid TreeDicItem dic) {
        iTreeDicStorage.add(dic);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_UPDATE)
    @PostMapping(value = "/update.do")
    @OperationLog(value = "修改树形字典[{0}-{1}]", spel = {"#dic.dicType", "#dic.code"}, type = OperationType.BASE)
    public InvocationResult update(@ParamValid TreeDicItem dic) {
        iTreeDicStorage.edit(dic);
        return new InvocationResult(dic);
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DELETE)
    @PostMapping(value = "/delete.do")
    @OperationLog(value = "删除树形字典[{0}-{1}]", spel = {"#dicType", "#code"}, type = OperationType.BASE)
    public InvocationResult delete(@ParamValid String dicType, @ParamValid String code) {
        iTreeDicStorage.deleteAll(dicType, code);
        return InvocationResult.SUCCESS;
    }

}