package com.helpframework.controller;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.HelpManageUtil;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.exception.UnifyErrorCode;
import com.help.config.HelpManageConfig;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.constant.UserConfigConstant;
import com.help.service.UserConfigService;
import com.help.storage.editable.IEditableUserStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: YuBin-002726
 * @Date: 2019/10/11 16:52
 */
@RestController
public class EditPasswordController {

    @Autowired
    private HelpManageConfig helpManageConfig;
    @Autowired
    IEditableUserStorage iUserStorage;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;
    @Autowired
    private UserConfigService pUserConfigService;

    //修改密码
    @ResponseBody
    @PostMapping(value = "/editPassword.do")
    @OperationLog(value = "修改登录密码", type = OperationType.BASE)
    @UnifyAuthorization(module = PermissionConstant.PERSONAL_CENTER_MENU, moduleName = "个人中心", op = "edit_password", opName = "修改密码", grantToAll = true)
    public InvocationResult editPassword(@ParamValid String oldPwd, @ParamValid String newPwd) {
        //检测强密码
        if (helpManageConfig.isStrongCipher()) {
            if (!HelpManageUtil.strongCipherValid(newPwd)) {
                return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, "新密码长度不得少于8位,且包含数字,大写字母,小写字母,特殊符号中的三种及以上");
            }
        } else if (newPwd.length() < 6) {
            return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, "密码长度必须超过6位");
        }

        String userNo = iTokenContext.getCurrentToken().getUserId();
        boolean succ = iUserStorage.resetPwd(userNo, oldPwd, newPwd);
        if (succ) {
            //移除弱密码标记
            if (helpManageConfig.isStrongCipher()) {
                pUserConfigService.delete(userNo, UserConfigConstant.WEAK_PASSWORD_TAG);
            }
            return InvocationResult.SUCCESS;
        } else {
            return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD, "原密码输入错误");
        }

    }

}
