package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.util.StringUtil;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.domain.OrgInfoBase;
import com.help.storage.editable.IEditableOrgStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统机构表 控制器
 * 对应数据库表 P_ORG
 *
 * @Generator help.mybatis.generator.plugins.HelpPlantformControllerPlugin
 */
@RestController
@UnifyAuthorization(module = PermissionConstant.CONFIG_ORG_MENU, moduleName = "机构管理", system = CommonConstant.YES)
@RequestMapping("/org")
public class EditOrgController {
    @Autowired
    private IEditableOrgStorage iOrgStorage;

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_ADD)
    @PostMapping(value = "/create.do")
    @OperationLog(value = "创建机构[{0}-{1}]", spel = {"#orgInfoBase.orgNo", "#orgInfoBase.orgName"}, type = OperationType.BASE)
    public InvocationResult create(@ParamValid OrgInfoBase orgInfoBase) {
        IEditableOrgStorage iEditableOrgService = iOrgStorage;
        if (StringUtil.isEmpty(orgInfoBase.getParentNo())) {
            orgInfoBase.setParentNo(null);
        }
        iEditableOrgService.add(orgInfoBase);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_UPDATE)
    @PostMapping(value = "/update.do")
    @OperationLog(value = "修改机构[{0}-{1}]", spel = {"#orgInfoBase.orgNo", "#orgInfoBase.orgName"}, type = OperationType.BASE)
    public InvocationResult update(@ParamValid OrgInfoBase orgInfoBase) {
        IEditableOrgStorage iEditableOrgService = iOrgStorage;
        if (StringUtil.isEmpty(orgInfoBase.getParentNo())) {
            orgInfoBase.setParentNo(null);
        }
        iEditableOrgService.edit(orgInfoBase);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DELETE)
    @PostMapping(value = "/delete.do")
    @OperationLog(value = "删除机构[{0}]", spel = {"#orgNo"}, type = OperationType.BASE)
    public InvocationResult delete(@ParamValid String orgNo) {
        iOrgStorage.delete(orgNo);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DELETE)
    @PostMapping(value = "/deleteDeep.do")
    @OperationLog(value = "删除机构及子集[{0}]", spel = {"#orgNo"}, type = OperationType.BASE)
    public InvocationResult deleteDeep(@ParamValid String orgNo) {
        iOrgStorage.deleteWithAll(orgNo);
        return InvocationResult.SUCCESS;
    }

}