package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.domain.LegalInfo;
import com.help.storage.editable.IEditableLegalStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/legal")
@UnifyAuthorization(module = PermissionConstant.CONFIG_LEGAL_MENU, moduleName = "法人管理", system = CommonConstant.YES)
public class EditLegalController {

    @Autowired
    private IEditableLegalStorage iEditableLegalStorage;

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_ADD)
    @PostMapping(value = "/create.do")
    @OperationLog(value = "创建法人[{0}-{1}}]", spel = {"#legalInfo.legalNo", "#legalInfo.legalName"}, type = OperationType.BASE)
    public InvocationResult create(@ParamValid LegalInfo legalInfo) {
        iEditableLegalStorage.add(legalInfo);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_UPDATE)
    @PostMapping(value = "/update.do")
    @OperationLog(value = "修改法人[{0}]", spel = {"#legalInfo.legalNo"}, type = OperationType.BASE)
    public InvocationResult update(@ParamValid LegalInfo legalInfo) {
        iEditableLegalStorage.edit(legalInfo);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DELETE)
    @PostMapping(value = "/delete.do")
    @OperationLog(value = "删除法人[{0}]", spel = {"#legalNo"}, type = OperationType.BASE)
    public InvocationResult delete(@ParamValid String legalNo) {
        iEditableLegalStorage.delete(legalNo);
        return InvocationResult.SUCCESS;
    }

}
