package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.domain.DicItem;
import com.help.storage.editable.IEditableDicStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 对应数据库表 p_dic
 */
@RestController
@UnifyAuthorization(module = PermissionConstant.CONFIG_DIC_MENU, moduleName = "字典配置", system = CommonConstant.YES)
@RequestMapping("/pDic")
public class EditDicController {
    @Autowired
    private IEditableDicStorage iEditableDicStorage;

    @PostMapping(value = "/create.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_ADD)
    @OperationLog(value = "创建字典[{0}-{1}-{2}]", spel = {"#dic.dicType", "#dic.code", "#dic.text"}, type = OperationType.BASE)
    public InvocationResult create(@ParamValid DicItem dic) {
        iEditableDicStorage.add(dic);
        return InvocationResult.SUCCESS;
    }

    @PostMapping(value = "/update.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_UPDATE)
    @OperationLog(value = "修改字典[{0}]", spel = {"#dic.dicType", "#dic.code"}, type = OperationType.BASE)
    public InvocationResult update(@ParamValid DicItem dic) {
        iEditableDicStorage.edit(dic);
        return new InvocationResult(dic);
    }

    @PostMapping(value = "/delete.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DELETE)
    @OperationLog(value = "删除字典[{0}-{1}]", spel = {"#dicType", "#code"}, type = OperationType.BASE)
    public InvocationResult delete(@ParamValid String dicType, @ParamValid String code) {
        iEditableDicStorage.delete(dicType, code);
        return InvocationResult.SUCCESS;
    }

}