package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.StringUtil;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.domain.DeptInfo;
import com.help.storage.editable.IEditableDeptStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/dept")
@UnifyAuthorization(module = PermissionConstant.CONFIG_DEPT_MENU, moduleName = "部门管理", system = CommonConstant.YES)
public class EditDeptController {

    @Autowired
    private IEditableDeptStorage deptService;

    @PostMapping(value = "/create.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_ADD)
    @OperationLog(value = "创建部门[{0}-{1}]", spel = {"#dept.deptNo", "#dept.deptName"}, type = OperationType.BASE)
    public InvocationResult create(@ParamValid DeptInfo dept) {
        deptService.add(dept);
        return InvocationResult.SUCCESS;
    }

    @PostMapping(value = "/update.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_UPDATE)
    @OperationLog(value = "修改部门[{0}]", spel = {"#dept.deptNo"}, type = OperationType.BASE)
    public InvocationResult update(@ParamValid DeptInfo dept) {
        if (StringUtil.isNotEmpty(dept.getDeptNo())) {
            deptService.edit(dept);
        } else {
            throw new UnifyValidateException("请求参数不合法,缺少更新条件");
        }

        return InvocationResult.SUCCESS;
    }

    @PostMapping(value = "/delete.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DELETE)
    @OperationLog(value = "删除部门[{0}]", spel = {"#deptNo"}, type = OperationType.BASE)
    public InvocationResult delete(@ParamValid String deptNo) {
        deptService.delete(deptNo);
        return InvocationResult.SUCCESS;
    }

}
