package com.help.web.module;

import com.help.common.util.StringUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 功能模块
 *
 * @author: YuBin-002726
 * @Date: 2019/3/5 19:24
 */
public class Module implements Serializable {

    /**
     * 模块编号
     */
    private String module;

    /**
     * 模块名称
     */
    private String name;

    /**
     * 是否为系统模块
     */
    private String system;

    /**
     * 模块下拥有的功能列表
     */
    private List<Operation> operations = new ArrayList<>();

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSystem() {
        return system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getModule() {
        return module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public List<Operation> getOperations() {
        return operations;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public void addOperation(Operation op) {
        if (operations == null) {
            operations = new ArrayList<>();
        }
        Operation old = operations.stream().filter(p -> p.getOp().equalsIgnoreCase(op.getOp())).findAny().orElse(null);
        if (old == null) {
            operations.add(op);
        } else if (StringUtil.isEmptyAll(old.getName())) {
            old.setName(op.getName());
        }
    }
}
