package com.help.web.module;

import java.io.Serializable;
import java.util.List;

/**
 * 前台需要的单个菜单项
 * @author YuBin-002726
 *
 */
public class MenuItem implements Serializable {
	/**
	 * 菜单项属性
	 * @author YuBin-002726
	 *
	 */
	public static class MenuItemAttribute{
		public MenuItemAttribute(String url,int outLink){
			this.url = url;
			this.outLink = outLink;
		}
		
		public String getUrl() {
			return url;
		}

		public void setUrl(String url) {
			this.url = url;
		}

		public int getOutLink() {
			return outLink;
		}

		public void setOutLink(int outLink) {
			this.outLink = outLink;
		}

		private int outLink;
		private String url;
	}
	
	private String id;
	private String text;
	private String state;
	private Integer order;
	private String iconCls;
	private String module;
	private String op;
	private MenuItemAttribute attributes;
	private List<MenuItem> children;
	
	public String getIconCls() {
		return iconCls;
	}
	public void setIconCls(String iconCls) {
		this.iconCls = iconCls;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public String getState() {
		return state;
	}
	public void setState(String state) {
		this.state = state;
	}
	public Integer getOrder() {
		return order;
	}
	public void setOrder(Integer order) {
		this.order = order;
	}
	public MenuItemAttribute getAttributes() {
		return attributes;
	}
	public void setAttributes(MenuItemAttribute attributes) {
		this.attributes = attributes;
	}
	public List<MenuItem> getChildren() {
		return children;
	}
	public void setChildren(List<MenuItem> children) {
		this.children = children;
	}

	public String getModule() {
		return module;
	}

	public void setModule(String module) {
		this.module = module;
	}

	public String getOp() {
		return op;
	}

	public void setOp(String op) {
		this.op = op;
	}
}
