package com.help.web.controller;

import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.constant.PermissionConstant;
import com.help.storage.ITreeDicStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统树形字典表 控制器
 * 对应数据库表 P_TREE_DIC
 *
 * @Generator help.mybatis.generator.plugins.HelpPlantformControllerPlugin
 */
@RestController
@UnifyAuthorization(module = PermissionConstant.CONFIG_TREEDIC_MENU, moduleName = "树形字典配置", system = CommonConstant.YES)
@RequestMapping("/treedic")
public class TreeDicController {
    @Autowired
    private ITreeDicStorage iTreeDicStorage;

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DETAIL)
    @PostMapping(value = "/detail.do")
    public InvocationResult detail(@ParamValid String dicType, @ParamValid String code) {
        return new InvocationResult(iTreeDicStorage.get(dicType, code));
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/listByType.do")
    public InvocationResult listByType(@ParamValid String dicType) {
        return new InvocationResult(iTreeDicStorage.list(dicType));
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/listType.do")
    public InvocationResult list() {
        return new InvocationResult(iTreeDicStorage.listTypes());
    }
}