package com.help.web.controller;

import com.help.annotation.OperationLog;
import com.help.common.ICacheable;
import com.help.common.InvocationResult;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.util.StringUtil;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.constant.PermissionConstant;
import com.help.constraint.IHelpSystemComponent;
import com.help.constraint.IHelpSystemServer;
import com.help.constraint.IHelpSystemSocketServer;
import com.help.annotation.UnifyAuthorization;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 系统server控制器 查看，启动，关闭
 *
 * @author JM-SM
 */
@RestController
@UnifyAuthorization(module = "config_service", moduleName = "系统服务管理", system = CommonConstant.YES)
@RequestMapping("/systemServer")
public class SystemServerController {

    @Autowired(required = false)
    private Map<String, IHelpSystemComponent> iUnifyComponents;

    /**
     * 查看所有的服务
     *
     * @return
     */
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/list.do")
    public InvocationResult list(String serviceName) {
        List<Map<String, Object>> unifyList = new ArrayList<>();
        if (iUnifyComponents != null) {
            for (Map.Entry<String, IHelpSystemComponent> kv : iUnifyComponents.entrySet()) {
                IHelpSystemComponent iUnifyComponent = kv.getValue();

                if (StringUtil.isNotEmpty(serviceName)) {
                    if (kv.getKey().indexOf(serviceName) < 0 && iUnifyComponent.getName().indexOf(serviceName) < 0) {
                        break;
                    }
                }

                Map<String, Object> map = new HashMap<>();
                map.put("name", kv.getKey());
                map.put("serviceName", iUnifyComponent.getName());
                if (iUnifyComponent instanceof IHelpSystemSocketServer || iUnifyComponent instanceof IHelpSystemServer) {
                    map.put("serviceStatus", ((IHelpSystemServer) iUnifyComponent).isRunning());
                    map.put("type", "server");
                } else {
                    map.put("serviceStatus", true);
                    map.put("type", "component");
                }

                if (iUnifyComponent instanceof IHelpSystemSocketServer) {
                    IHelpSystemSocketServer unifySockey = (IHelpSystemSocketServer) iUnifyComponent;
                    if (unifySockey.isRunning()) {
                        map.put("port", unifySockey.getPort());
                    }
                }

                if (iUnifyComponent instanceof ICacheable) {
                    map.put("refreshable", true);
                } else {
                    map.put("refreshable", false);
                }
                unifyList.add(map);
            }
        }
        return new InvocationResult(unifyList);
    }

    /**
     * 启动服务
     *
     * @param name
     */
    @UnifyAuthorization(op = "start", opName = "启动服务")
    @PostMapping(value = "/start.do")
    @OperationLog(value = "启动服务[{0}]", spel = "#name", type = OperationType.SYSTEM)
    public InvocationResult start(String name) {
        IHelpSystemComponent iUnifyComponent = iUnifyComponents.get(name);
        if (iUnifyComponent instanceof IHelpSystemServer) {
            IHelpSystemServer iUnifyServer = (IHelpSystemServer) iUnifyComponent;
            if (iUnifyServer.isRunning()) {
                return new InvocationResult(UnifyErrorCode.UNKNOW_FAIL, "启动失败，服务已开启");
            } else {
                iUnifyServer.start();
                return InvocationResult.SUCCESS;
            }
        } else {
            return new InvocationResult(UnifyErrorCode.UNKNOW_FAIL, "该服务无法手动启停");
        }

    }

    /**
     * 关闭服务
     *
     * @param name
     */
    @UnifyAuthorization(op = "stop", opName = "关闭服务")
    @PostMapping(value = "/stop.do")
    @OperationLog(value = "关闭服务[{0}]", spel = "#name", type = OperationType.SYSTEM)
    public InvocationResult stop(String name) {
        IHelpSystemComponent iUnifyComponent = iUnifyComponents.get(name);

        if (iUnifyComponent instanceof IHelpSystemServer) {
            IHelpSystemServer iUnifyServer = (IHelpSystemServer) iUnifyComponent;

            if (iUnifyServer.isRunning()) {
                iUnifyServer.stop();
            }
            return InvocationResult.SUCCESS;
        } else {
            return new InvocationResult(UnifyErrorCode.UNKNOW_FAIL, "该服务无法手动启停");
        }

    }

}
