package com.help.web.controller;

import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.constant.PermissionConstant;
import com.help.domain.RoleInfo;
import com.help.storage.IRoleStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/role")
@UnifyAuthorization(module = PermissionConstant.CONFIG_ROLE_MENU, moduleName = "角色管理", system = CommonConstant.YES)
public class RoleController {

    @Autowired
    private IRoleStorage iRoleStorage;

    @PostMapping(value = "/detail.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DETAIL)
    public InvocationResult detail(@ParamValid String roleNo) {
        return new InvocationResult(iRoleStorage.get(roleNo));
    }

    @RequestMapping(value = "/list.do", method = RequestMethod.POST)
    public InvocationResult list() {
        return new InvocationResult(iRoleStorage.list());
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/listByPage.do")
    public InvocationResult listByPage(UnifyPageInfo page, @RequestParam(required = false) String name) {
        UnifyPageData<RoleInfo> list = iRoleStorage.searchByPage(name, page);
        return new InvocationResult(list);
    }
}
