package com.help.web.controller;

import com.help.annotation.OperationLog;
import com.help.common.*;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.constant.OperationType;
import com.help.domain.PParam;
import com.help.domain.PParamExample;
import com.help.annotation.UnifyAuthorization;
import com.help.constant.PermissionConstant;
import com.help.service.manage.PParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统参数表 控制器
 * 对应数据库表 P_PARAM
 *
 * @Generator help.mybatis.generator.plugins.HelpPlantformControllerPlugin
 */
@RestController
@UnifyAuthorization(module = "config_param", moduleName = "系统参数配置", system = CommonConstant.YES)
@RequestMapping("/pParam")
public class PParamController {
    private static final Logger logger = LoggerFactory.getLogger(PParamController.class);

    @Autowired
    private PParamService pParamService;

    @Autowired
    IParamReader paramReader;

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_ADD)
    @PostMapping(value = "/create.do")
    @OperationLog(value = "创建系统参数[{0}]", spel = "#pParam.paramKey", type = OperationType.SYSTEM)
    public InvocationResult create(@ParamValid PParam pParam) {
        pParamService.add(pParam);
        if (paramReader instanceof ICacheable) {
            ((ICacheable) paramReader).refresh();
        }
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_UPDATE)
    @PostMapping(value = "/update.do")
    @OperationLog(value = "修改系统参数[{0}]", spel = "#pParam.paramKey", type = OperationType.SYSTEM)
    public InvocationResult update(@ParamValid PParam pParam) {
        pParamService.update(pParam);
        if (paramReader instanceof ICacheable) {
            ((ICacheable) paramReader).refresh();
        }
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DELETE)
    @PostMapping(value = "/delete.do")
    @OperationLog(value = "删除系统参数[{0}]", spel = "#paramKey", type = OperationType.SYSTEM)
    public InvocationResult delete(@ParamValid String paramKey) {
        pParamService.delete(paramKey);
        if (paramReader instanceof ICacheable) {
            ((ICacheable) paramReader).refresh();
        }
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DETAIL)
    @PostMapping(value = "/detail.do")
    public InvocationResult detail(@ParamValid String paramKey) {
        PParam detail = pParamService.get(paramKey);
        return new InvocationResult(detail);
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/listByPage.do")
    public InvocationResult listByPage(UnifyPageInfo page, PParam pParam) {
        UnifyPageData<PParam> list = pParamService.list(page, ExampleConvert.toLikeExample(pParam, PParamExample.class));
        return new InvocationResult(list);
    }

    @UnifyAuthorization(op = "publish", opName = "推送参数变更通知")
    @PostMapping(value = "/publish.do")
    public InvocationResult publish() {
        if (paramReader instanceof ICacheable) {
            ((ICacheable) paramReader).refresh();
        }
        return InvocationResult.SUCCESS;
    }
}