package com.help.web.controller;

import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.util.StringUtil;
import com.help.constant.CommonConstant;
import com.help.constant.PermissionConstant;
import com.help.domain.OrgInfoBase;
import com.help.domain.OrgNode;
import com.help.storage.IOrgStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 系统机构表 控制器
 * 对应数据库表 P_ORG
 *
 * @Generator help.mybatis.generator.plugins.HelpPlantformControllerPlugin
 */
@RestController
@UnifyAuthorization(module = PermissionConstant.CONFIG_ORG_MENU, moduleName = "机构管理", system = CommonConstant.YES)
@RequestMapping("/org")
public class OrgController {
    @Autowired
    private IOrgStorage iOrgStorage;

    @PostMapping(value = "/detail.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DETAIL)
    public InvocationResult detail(@ParamValid String orgNo) {
        return new InvocationResult(iOrgStorage.get(orgNo));
    }

    @PostMapping(value = "/parent.do")
    public InvocationResult parent(@ParamValid String orgNo) {
        OrgInfoBase base = iOrgStorage.get(orgNo);
        if (base == null || StringUtil.isEmpty(base.getParentNo())) {
            return new InvocationResult();
        } else {
            return new InvocationResult(iOrgStorage.get(base.getParentNo()));
        }
    }

    @PostMapping(value = "/listChildrens.do")
    public InvocationResult getChilds(String orgNo) {
        if (StringUtil.isEmpty(orgNo)) {
            return new InvocationResult(iOrgStorage.listTopWithChilds());
        }
        OrgNode node = iOrgStorage.getWithChilds(orgNo, 2);
        if (node != null && node.getChildren() != null) {
            return new InvocationResult(node.getChildren());
        } else {
            return new InvocationResult(new ArrayList<>());
        }
    }

    @PostMapping(value = "/list.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    public InvocationResult list() {
        return new InvocationResult(iOrgStorage.listTopWithAll());
    }

    @PostMapping(value = "/listByType.do")
    public InvocationResult listByType(@ParamValid String type, String legal) {
        List<OrgInfoBase> list = iOrgStorage.listByType(type);
        if (StringUtil.isNotEmpty(legal)) {
            list = list.stream().filter(p -> legal.equalsIgnoreCase(p.getLegalPersonality())).collect(Collectors.toList());
        } else {
            list = list.stream().filter(p -> StringUtil.isEmpty(p.getLegalPersonality())).collect(Collectors.toList());
        }
        return new InvocationResult(list);
    }

}