package com.help.web.controller;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.util.StringUtil;
import com.help.constraint.IHelpOAuthClient;
import com.help.domain.UserInfo;
import com.help.storage.IUserStorage;
import com.help.service.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import java.util.HashMap;
import java.util.Map;

@Controller
@RequestMapping("/oauth")
public class OAuthController {

    @Autowired(required = false)
    IHelpOAuthClient ioAuthClient;
    @Autowired
    PermissionService permissionService;
    @Autowired
    IUserStorage iUserStorage;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;

    @ResponseBody
    @PostMapping("/info.do")
    public InvocationResult<Map> info(String redirectUrl) {
        if (ioAuthClient != null) {
            Map<String, String> map = new HashMap<>();
            map.put("loginUrl", ioAuthClient.loginUrl(redirectUrl));
            map.put("oauthName", ioAuthClient.systemName());

            return new InvocationResult<>(map);
        } else {
            return new InvocationResult<>();
        }
    }

    @ResponseBody
    @UnifyAuthorization
    @PostMapping("/bind-info.do")
    public InvocationResult bindInfo(String redirectUrl) {
        if (ioAuthClient != null) {
            UserInfo user = iTokenContext.getCurrentToken().getCurrentUser();
            Map<String, String> result = new HashMap<>();
            result.put("oauthName", ioAuthClient.systemName());
            result.put("oauthIndex", ioAuthClient.indexUrl());
            result.put("loginUrl", ioAuthClient.loginUrl(redirectUrl));
            String oauthUser = ioAuthClient.oauthUser(user.getUserNo());
            if (StringUtil.isNotEmpty(oauthUser)) {
                result.put("oauthUser", oauthUser);
            } else {
                String bindUrl = ioAuthClient.bindUrl(user.getUserNo(), user.getUserName(), redirectUrl);
                result.put("bindUrl", bindUrl);
            }

            return new InvocationResult(result);
        } else {
            return new InvocationResult();
        }
    }



}
