package com.help.web.controller;

import com.help.common.InvocationResult;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.domain.DicItem;
import com.help.annotation.UnifyAuthorization;
import com.help.constant.PermissionConstant;
import com.help.storage.IDicStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 对应数据库表 p_dic
 */
@RestController
@UnifyAuthorization(module = PermissionConstant.CONFIG_DIC_MENU, moduleName = "字典配置", system = CommonConstant.YES)
@RequestMapping("/pDic")
public class DicController {
    @Autowired
    private IDicStorage iDicStorage;

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DETAIL)
    @PostMapping(value = "/detail.do")
    public InvocationResult detail(@ParamValid String dicType, @ParamValid String code) {
        return new InvocationResult(iDicStorage.get(dicType, code));
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/listByPage.do")
    public InvocationResult listByPage(UnifyPageInfo page, String dicType) {
        UnifyPageData<DicItem> list = iDicStorage.searchByPage(dicType, page);
        return new InvocationResult(list);
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/listType.do")
    public InvocationResult list() {
        return new InvocationResult(iDicStorage.listTypes());
    }
}