package com.help.web.controller;

import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.annotation.ParamValid;
import com.help.constant.CommonConstant;
import com.help.constant.PermissionConstant;
import com.help.domain.DeptInfo;
import com.help.storage.IDeptStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/dept")
@UnifyAuthorization(module = PermissionConstant.CONFIG_DEPT_MENU, moduleName = "部门管理", system = CommonConstant.YES)
public class DeptController {

    @Autowired
    private IDeptStorage deptStorage;

    @PostMapping(value = "/detail.do")
    @UnifyAuthorization(op = PermissionConstant.PERMISSION_DETAIL)
    public InvocationResult detail(@ParamValid String deptNo) {
        return new InvocationResult(deptStorage.get(deptNo));
    }

    @RequestMapping(value = "/list.do", method = RequestMethod.POST)
    public InvocationResult list() {
        return new InvocationResult(deptStorage.list());
    }

    @UnifyAuthorization(op = PermissionConstant.PERMISSION_VISIT)
    @PostMapping(value = "/listByPage.do")
    public InvocationResult listByPage(UnifyPageInfo page, @RequestParam(required = false) String name) {
        UnifyPageData<DeptInfo> list = deptStorage.searchByPage(name, page);
        return new InvocationResult(list);
    }

}
