package com.help.web.aop;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.service.LoginService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

/**
 * HELP管理平台Mock组件
 *
 * @author: YuBin-002726
 * @Date: 2019/2/22 13:56
 */
@Aspect
public class MockTokenAspect {

    @Autowired
    private LoginService loginService;

    private HelpManageConfig config;

    private ThreadLocal<String> local = new ThreadLocal<>();

    public MockTokenAspect(HelpManageConfig config) {
        this.config = config;
    }

    @Autowired
    HttpServletRequest request;

    @Around("within(com.help.ITokenContext+) && execution(* getCurrentToken(..))")
    public Object exec(ProceedingJoinPoint pjp) throws Throwable {

        Object token = pjp.proceed();

        if (local.get() == null) {
            if (token == null && this.config.getMockToken().equals(getCurrentTokenKey(request))) {
                try {
                    local.set("1");
                    LoginInfo loginInfo = null;
                    if (config.getMockUserInfo() != null) {
                        loginInfo = config.getMockUserInfo();
                    } else {
                        loginInfo = loginService.getToken(this.config.getMockUser());
                    }

                    loginInfo.setToken(this.config.getMockToken());

                    ITokenContext<LoginInfo> iTokenContext = (ITokenContext) pjp.getTarget();
                    iTokenContext.saveToken(loginInfo);

                    return loginInfo;
                } finally {
                    local.remove();
                }
            } else {
                return token;
            }
        } else {
            return token;
        }
    }


    private String getCurrentTokenKey(HttpServletRequest request) {
        String tokenKey = request.getHeader(config.getMockKey());
        if (StringUtil.isEmpty(tokenKey)) {
            tokenKey = request.getParameter(config.getMockKey());
        }
        return tokenKey;
    }

}
