package com.help.web.aop;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.constant.PermissionConstant;
import com.help.storage.legal.ILegalableStorage;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * @author: YuBin-002726
 * @Date: 2019/9/25 10:24
 */
@Aspect
public class HelpLegalableStorageAutoSwitchAspect {

    @Autowired
    ITokenContext<LoginInfo> iTokenContext;

    @Autowired
    HelpManageConfig helpManageConfig;

    @Around("within(com.help.storage.legal.ILegalableStorage+) && execution(public * *(..)) && !execution(public * getLegalProxy(String)) && !execution(public * getEditableLegalProxy(String)))")
    public Object edit(ProceedingJoinPoint joinPoint) throws Throwable {
        if (helpManageConfig.isMultiLegalEnable()) {
            if (iTokenContext != null) {
                LoginInfo loginInfo = iTokenContext.getCurrentToken();
                if (loginInfo != null && loginInfo.getLoginRoles() != null && !loginInfo.getLoginRoles().contains(PermissionConstant.ROLE_ADMIN) && StringUtil.isNotEmpty(loginInfo.getLegalPersonality())) {
                    String legal = loginInfo.getLegalPersonality();

                    Object target = ((ILegalableStorage) joinPoint.getTarget()).getLegalProxy(legal);

                    Method method = ((MethodSignature) joinPoint.getSignature()).getMethod();

                    try {
                        Method mtd = target.getClass().getMethod(method.getName(), method.getParameterTypes());
                        return mtd.invoke(target, joinPoint.getArgs());
                    } catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
            }
        }
        return joinPoint.proceed();
    }

}
