package com.help.validator;

import com.help.annotation.InDic;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.Convert;
import com.help.common.validate.intf.IFieldValidator;
import com.help.domain.DicItem;
import com.help.domain.TreeDicItem;
import com.help.service.DictionaryService;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: YuBin-002726
 * @Date: 2019/9/16 9:57
 */
public class InDicFieldValidator implements IFieldValidator<InDic, Object> {

    @Autowired
    DictionaryService dictionaryService;

    @Override
    public void validate(Field field, Object value, Object o, InDic anno) {

        List<String> arr = null;

        List<DicItem> items = dictionaryService.list(anno.value());
        if (items != null && items.size() > 0) {
            arr = items.stream().map(p -> p.getCode()).collect(Collectors.toList());
        } else {
            List<TreeDicItem> dics = dictionaryService.listTree(anno.value());
            if (dics != null && dics.size() > 0) {
                arr = dics.stream().map(p -> p.getCode()).collect(Collectors.toList());
            }
        }

        if (arr != null && arr.size() > 0) {
            if (value instanceof Number) {
                value = Convert.toString(value);
            }
            if (value instanceof String) {
                boolean contain = false;
                for (String s : arr) {
                    if (((String) value).equalsIgnoreCase(s)) {
                        contain = true;
                        break;
                    }
                }
                if (!contain) {
                    throw new UnifyValidateException(HelpValidator.getFieldName(field) + "的取值不在字典[" + anno.value() + "]允许的范围内");
                }
            }
        }
    }
}
