package com.help.service.manage;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.constraint.ISearchable;
import com.help.dao.PParamMapper;
import com.help.dao.batch.BatchExecuter;
import com.help.dao.batch.BatchHelper;
import com.help.dao.batch.IExecuteSingleAction;
import com.help.domain.PParam;
import com.help.domain.PParamExample;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 系统参数表 业务类
 * 对应数据库表 P_PARAM
 *
 * @Generator help.mybatis.generator.plugins.HelpPlantformServicePlugin
 */
@Service
public class PParamService implements ISearchable<PParam, PParamExample> {
    @Autowired
    private PParamMapper mapper;

    @Autowired
    private BatchHelper batchHelper;

    /**
     * 插入一条系统参数表数据,并返回插入结果 若实体中包含@SequenceGenerator注解且值为空,则自动为其生成编号
     *
     * @param entity 要插入的系统参数表实体
     * @return 插入的实体
     */
    public PParam add(PParam entity) {
        mapper.insert(entity);
        return entity;
    }

    /**
     * 批量插入系统参数表数据 若实体中包含@SequenceGenerator注解且值为空,则自动为其生成编号
     *
     * @param list 要插入的系统参数表数据实体
     */
    @Transactional
    public void addBatch(List<PParam> list) {
        BatchExecuter<PParamMapper> executer = batchHelper.getBatchExecuter(PParamMapper.class);
        executer.execute(list, new IExecuteSingleAction<PParamMapper, PParam>() {
            @Override
            public void execute(PParamMapper dao, PParam entity) {
                dao.insert(entity);
            }
        });
    }

    /**
     * 根据系统参数表实体的主键更新数据的全部字段
     *
     * @param entity 要更新的系统参数表数据实体
     * @throws UnifyException 当未有任何数据更新则抛出异常
     */
    public void update(PParam entity) {
        if (mapper.updateByPrimaryKey(entity) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    /**
     * 根据系统参数表实体的主键更新实体中的非空字段
     *
     * @param entity 要更新的系统参数表数据实体
     * @throws UnifyException 当未有任何数据更新则抛出异常
     */
    public void updateSelective(PParam entity) {
        if (mapper.updateByPrimaryKeySelective(entity) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    /**
     * 根据系统参数表实体的主键删除数据
     *
     * @param key 要删除的系统参数表数据主键
     * @throws UnifyException 当未有任何数据删除则抛出异常
     */
    public void delete(String key) {
        if (mapper.deleteByPrimaryKey(key) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    /**
     * 根据系统参数表实体的主键获取数据
     *
     * @param key 要获取的系统参数表数据主键
     * @return 获取到的数据 没有数据则返回null
     */
    public PParam get(String key) {
        return mapper.selectByPrimaryKey(key);
    }

    /**
     * 获取所有系统参数表数据
     *
     * @return 获取到的系统参数表数据 没有数据则返回size为0的List
     */
    public List<PParam> list() {
        return mapper.selectByExample(null);
    }

    /**
     * 根据条件获取系统参数表数据
     *
     * @param example 查询条件 若不提供则查询所有数据
     * @param columns 要查询的列 若不提供则查询所有列
     * @return 获取到的系统参数表数据 没有数据则返回size为0的List
     */
    public List<PParam> list(PParamExample example, String... columns) {
        if (columns == null || columns.length == 0) {
            return mapper.selectByExample(example);
        } else {
            return mapper.selectColumnsByExample(example, columns);
        }
    }

    /**
     * 分页获取所有系统参数表数据
     *
     * @param pageInfo 分页信息
     * @return 获取到的系统参数表数据 没有数据则返回size为0的UnifyPageData
     */
    public UnifyPageData<PParam> list(UnifyPageInfo pageInfo) {
        PageHelper.startPage(pageInfo.getPageIndex(), pageInfo.getPageSize());
        List<PParam> list = mapper.selectByExample(null);
        PageInfo<PParam> info = new PageInfo<PParam>(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData<PParam>(info.getList(), pageInfo);
    }

    /**
     * 根据条件分页获取系统参数表数据
     *
     * @param pageInfo 分页信息
     * @param example  查询条件 若不提供则查询所有数据
     * @param columns  要查询的列 若不提供则查询所有列
     * @return 获取到的系统参数表数据 没有数据则返回size为0的UnifyPageData
     */
    public UnifyPageData<PParam> list(UnifyPageInfo pageInfo, PParamExample example, String... columns) {
        PageHelper.startPage(pageInfo.getPageIndex(), pageInfo.getPageSize());
        List<PParam> list = null;
        if (columns == null || columns.length == 0) {
            list = mapper.selectByExample(example);
        } else {
            list = mapper.selectColumnsByExample(example, columns);
        }
        PageInfo<PParam> info = new PageInfo<PParam>(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData<>(info.getList(), pageInfo);
    }
}