package com.help.service;

import com.help.constant.CacheConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.UUID;

/**
 * @author: YuBin-002726
 * @Date: 2019/10/11 9:25
 */
@Service
public class ValidCodeService {

    @Autowired
    CacheValidCodeStorage cacheValidCodeStorage;

    /**
     * 为验证码创建对应的校验Key
     *
     * @param validCode
     * @return
     */
    public String createKey(String validCode) {
        String key = UUID.randomUUID().toString().replaceAll("-", "");
        return createKey(validCode, key);
    }

    /**
     * 为验证码创建对应的校验Key
     *
     * @param validCode 验证码
     * @param key       指定Key
     * @return
     */
    public String createKey(String validCode, String key) {
        cacheValidCodeStorage.save(key, validCode);
        return key;
    }

    /**
     * 校验验证码正确性
     *
     * @param key
     * @param validCode
     * @return
     */
    public boolean valid(String key, String validCode) {
        String code = cacheValidCodeStorage.getAndClean(key);
        if (code != null && code.equalsIgnoreCase(validCode)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 移除一个验证码校验Key
     *
     * @param key
     */
    public void removeKey(String key) {
        cacheValidCodeStorage.clean(key);
    }

    @Component
    public static class CacheValidCodeStorage {

        @Caching(cacheable = @Cacheable(value = CacheConstant.CACHE_SHORTTIME, key = "'VALID-CODE-'+#key"),
                evict = @CacheEvict(value = CacheConstant.CACHE_SHORTTIME, key = "'VALID-CODE-'+#key"))
        public String getAndClean(String key) {
            return null;
        }

        @Cacheable(value = CacheConstant.CACHE_SHORTTIME, key = "'VALID-CODE-'+#key")
        public String save(String key, String validCode) {
            return validCode;
        }

        @CacheEvict(value = CacheConstant.CACHE_SHORTTIME, key = "'VALID-CODE-'+#key")
        public void clean(String key) {

        }

    }

}
