package com.help.service;

import com.help.dao.PUserConfigMapper;
import com.help.domain.PUserConfig;
import com.help.domain.PUserConfigExample;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * 首页轮播配置 业务类
 * 对应数据库表 P_USER_CONFIG
 */
@Service
public class UserConfigService {
    @Autowired
    private PUserConfigMapper mapper;

    /**
     * 保存用户配置
     *
     * @param userNo 用户编号
     * @param name   配置名称
     * @param value  配置值
     */
    @Transactional
    public void save(String userNo, String name, String value) {
        PUserConfigExample example = new PUserConfigExample();
        example.createCriteria().andUserNoEqualTo(userNo).andNameEqualTo(name);

        PUserConfig config = new PUserConfig();
        config.setUserNo(userNo);
        config.setName(name);
        config.setValue(value);
        if (mapper.updateColumnsByExample(config, example, "value") == 0) {
            mapper.insert(config);
        }
    }

    /**
     * 是否存在某配置(无论其值是否为空)
     *
     * @param userNo
     * @param name
     * @return
     */
    public boolean contain(String userNo, String name) {
        PUserConfigExample example = new PUserConfigExample();
        example.createCriteria().andUserNoEqualTo(userNo).andNameEqualTo(name);

        return mapper.countByExample(example) > 0;
    }

    /**
     * 根据用户编号和配置名称获取用户配置值
     *
     * @param userNo
     * @param name
     * @return
     */
    public String get(String userNo, String name) {
        PUserConfig config = mapper.selectByPrimaryKey(userNo, name);
        if (config != null) {
            return config.getValue();
        } else {
            return null;
        }
    }

    public void delete(String userNo, String name) {
        mapper.deleteByPrimaryKey(userNo, name);
    }

    public Map<String, String> list(String userNo) {
        PUserConfigExample example = new PUserConfigExample();
        example.createCriteria().andUserNoEqualTo(userNo);

        return mapper.selectByExample(example).stream().collect(Collectors.toMap(PUserConfig::getName, PUserConfig::getValue));
    }

}