package com.help.service;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.dao.PRoleModuleOpMapper;
import com.help.domain.PRoleModuleOpExample;
import com.help.storage.IDeptStorage;
import com.help.storage.IOrgStorage;
import com.help.storage.IRoleStorage;
import com.help.storage.IUserStorage;
import com.help.storage.editable.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 用户/角色/机构复合业务
 *
 * @author: YuBin-002726
 * @Date: 2019/1/30 9:07
 */
@Service
public class UnionService {

    @Autowired
    IUserStorage iUserStorage;

    @Autowired
    IRoleStorage iRoleStorage;

    @Autowired
    IOrgStorage iOrgStorage;

    @Autowired
    IDeptStorage iDeptStorage;

    @Autowired
    PRoleModuleOpMapper pRoleModuleOpMapper;

    /**
     * 删除角色与角色相关的所有信息
     *
     * @param roleNo
     */
    @Transactional
    public void deleteRole(String roleNo) {
        if (iRoleStorage instanceof IEditableRoleStorage) {
            ((IEditableRoleStorage) iRoleStorage).delete(roleNo);

            //删除角色/菜单关联
            PRoleModuleOpExample pRoleMenuOpExample = new PRoleModuleOpExample();
            pRoleMenuOpExample.createCriteria().andRoleNoEqualTo(roleNo);

            pRoleModuleOpMapper.deleteByExample(pRoleMenuOpExample);
        } else {
            throw new UnifyException(UnifyErrorCode.NON_INTERFACE, "当前系统不支持角色的删除操作");
        }
    }

}
