package com.help.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.constraint.ISearchable;
import com.help.dao.POperationLogMapper;
import com.help.dao.batch.*;
import com.help.domain.POperationLog;
import com.help.domain.POperationLogExample;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 操作日志业务模块
 *
 * @author: Help-Generator Template By YuBin
 * @Date: 2019/9/29 14:06
 */
@Service
public class POperationLogService implements ISearchable<POperationLog, POperationLogExample> {
    @Autowired
    private POperationLogMapper mapper;

    @Autowired
    private BatchHelper batchHelper;

    /**
     * 插入一条数据,并返回插入结果 若实体中包含@SequenceGenerator注解且值为空,则自动为其生成编号
     *
     * @param entity 要插入的实体
     * @return 插入的实体
     */
    public POperationLog add(POperationLog entity) {
        mapper.insert(entity);
        return entity;
    }

    /**
     * 批量插入数据 若实体中包含@SequenceGenerator注解且值为空,则自动为其生成编号
     *
     * @param list 要插入的数据实体集合
     */
    @Transactional(rollbackFor = Throwable.class)
    public void addBatch(List<POperationLog> list) {
        BatchExecuter<POperationLogMapper> executer = batchHelper.getBatchExecuter(POperationLogMapper.class);
        executer.execute(list, new IExecuteSingleAction<POperationLogMapper, POperationLog>() {
            @Override
            public void execute(POperationLogMapper dao, POperationLog entity) {
                dao.insert(entity);
            }
        });
    }

    /**
     * 根据实体的主键更新数据的全部字段
     *
     * @param entity 要更新的数据实体
     * @throws UnifyException 当未有任何数据更新则抛出异常
     */
    public void update(POperationLog entity) {
        if (mapper.updateByPrimaryKey(entity) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    /**
     * 根据实体的主键更新实体中的非空字段
     *
     * @param entity 要更新的数据实体
     * @throws UnifyException 当未有任何数据更新则抛出异常
     */
    public void updateSelective(POperationLog entity) {
        if (mapper.updateByPrimaryKeySelective(entity) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    /**
     * 根据实体的主键删除数据
     *
     * @param id 要删除的数据主键
     * @throws UnifyException 当未有任何数据删除则抛出异常
     */
    public void delete(Long id) {
        if (mapper.deleteByPrimaryKey(id) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    /**
     * 根据实体的主键获取数据
     *
     * @param id 要获取的数据主键
     * @return 获取到的数据 没有数据则返回null
     */
    public POperationLog get(Long id) {
        return mapper.selectByPrimaryKey(id);
    }

    /**
     * 获取所有数据
     *
     * @return 获取到的数据 没有数据则返回size为0的List
     */
    public List<POperationLog> list() {
        return mapper.selectByExample(null);
    }

    /**
     * 根据条件获取数据
     *
     * @param example 查询条件 若不提供则查询所有数据
     * @param columns 要查询的列 若不提供则查询所有列
     * @return 获取到的数据 没有数据则返回size为0的List
     */
    @Override
    public List<POperationLog> list(POperationLogExample example, String... columns) {
        if (columns == null || columns.length == 0) {
            return mapper.selectByExample(example);
        } else {
            return mapper.selectColumnsByExample(example, columns);
        }
    }

    /**
     * 分页获取所有数据
     *
     * @param pageInfo 分页信息
     * @return 获取到的数据 没有数据则返回size为0的UnifyPageData
     */
    public UnifyPageData<POperationLog> list(UnifyPageInfo pageInfo) {
        PageHelper.startPage(pageInfo.getPageIndex(), pageInfo.getPageSize());
        List<POperationLog> list = mapper.selectByExample(null);
        PageInfo<POperationLog> info = new PageInfo<POperationLog>(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData<POperationLog>(info.getList(), pageInfo);
    }

    /**
     * 根据条件分页获取数据
     *
     * @param pageInfo 分页信息
     * @param example  查询条件 若不提供则查询所有数据
     * @param columns  要查询的列 若不提供则查询所有列
     * @return 获取到的数据 没有数据则返回size为0的UnifyPageData
     */
    public UnifyPageData<POperationLog> list(UnifyPageInfo pageInfo, POperationLogExample example, String... columns) {
        PageHelper.startPage(pageInfo.getPageIndex(), pageInfo.getPageSize());
        List<POperationLog> list = null;
        if (columns == null || columns.length == 0) {
            list = mapper.selectByExample(example);
        } else {
            list = mapper.selectColumnsByExample(example, columns);
        }
        PageInfo<POperationLog> info = new PageInfo<POperationLog>(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData<POperationLog>(info.getList(), pageInfo);
    }

    public void clean() {
        mapper.deleteByExample(null);
    }
}