package com.help.service;

import com.help.LoginInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.Convert;
import com.help.common.util.StringUtil;
import com.help.constant.CommonConstant;
import com.help.constant.PermissionConstant;
import com.help.constant.UserConfigConstant;
import com.help.domain.*;
import com.help.storage.IUserStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: YuBin-002726
 * @Date: 2019/2/22 14:13
 */
@Service
public class LoginService {

    @Autowired
    IUserStorage iUserStorage;
    @Autowired
    PermissionService permissionService;
    @Autowired
    UserConfigService userConfigService;

    private LoginInfo getToken(UserInfo userInfo) {
        if (userInfo != null) {
            if (!CommonConstant.DATA_STATUS_ENABLE.equalsIgnoreCase(userInfo.getState())) {
                throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "用户已停用");
            }
            LoginInfo loginInfo = new LoginInfo();
            loginInfo.setCurrentUser(userInfo);
            loginInfo.setUserId(userInfo.getUserNo());
            loginInfo.setLoginTime(new Date());

            //取用户机构l
            List<OrgInfoBase> orgs = permissionService.listOrgs(userInfo.getUserNo());

            //取用户部门
            List<DeptInfo> depts = permissionService.listDepts(userInfo.getUserNo());

            //取上次登录时间
            String lastLoginTime = userConfigService.get(userInfo.getUserNo(), UserConfigConstant.LAST_LOGIN_TIME);
            if (StringUtil.isNotEmpty(lastLoginTime)) {
                try {
                    loginInfo.setLastLoginTime(Convert.toDate(lastLoginTime, "yyyy-MM-dd HH:mm:ss"));
                } catch (Exception e) {
                }
            }
            userConfigService.save(userInfo.getUserNo(), UserConfigConstant.LAST_LOGIN_TIME, Convert.toString(loginInfo.getLoginTime(), "yyyy-MM-dd HH:mm:ss"));

            //取登录部门
            DeptInfo loginDept = null;
            String lastDept = userConfigService.get(userInfo.getUserNo(), UserConfigConstant.LAST_LOGIN_DEPT);
            if (StringUtil.isNotEmpty(lastDept)) {
                loginDept = depts.stream().filter(p -> p.getDeptNo().equalsIgnoreCase(lastDept)).findFirst().orElse(null);
            }
            //若首次登录,则自动设置登录部门
            if (StringUtil.isEmpty(lastLoginTime)) {
                if (loginDept == null && depts.size() > 0) {
                    loginDept = depts.get(0);
                }
            }
            if (loginDept != null) {
                loginInfo.setLoginDept(loginDept.getDeptNo());
                if (!loginDept.getDeptNo().equalsIgnoreCase(lastDept)) {
                    userConfigService.save(userInfo.getUserNo(), UserConfigConstant.LAST_LOGIN_DEPT, loginDept.getDeptNo());
                }
            } else if (StringUtil.isNotEmpty(lastDept)) {
                userConfigService.delete(userInfo.getUserNo(), UserConfigConstant.LAST_LOGIN_DEPT);
            }

            //取登录机构/法人
            OrgInfoBase loginOrg = null;
            String lastOrg = userConfigService.get(userInfo.getUserNo(), UserConfigConstant.LAST_LOGIN_ORG);
            if (StringUtil.isNotEmpty(lastOrg)) {
                loginOrg = orgs.stream().filter(p -> p.getOrgNo().equalsIgnoreCase(lastOrg)).findFirst().orElse(null);
            }
            //若首次登录,则自动设置登录机构
            if (StringUtil.isEmpty(lastLoginTime)) {
                if (loginOrg == null && orgs.size() > 0) {
                    loginOrg = orgs.get(0);
                }
            }
            if (loginOrg != null) {
                loginInfo.setLoginOrg(loginOrg.getOrgNo());

                if (!loginOrg.getOrgNo().equalsIgnoreCase(lastOrg)) {
                    userConfigService.save(userInfo.getUserNo(), UserConfigConstant.LAST_LOGIN_ORG, loginOrg.getOrgNo());
                }
            } else if (StringUtil.isNotEmpty(lastOrg)) {
                userConfigService.delete(userInfo.getUserNo(), UserConfigConstant.LAST_LOGIN_ORG);
            }

            //取可用角色
            List<String> roles = permissionService.listRoles(userInfo.getUserNo(), loginInfo.getLoginOrg(), loginInfo.getLoginDept(), false).stream().map(
                    p -> p.getRoleNo()
            ).collect(Collectors.toList());
            loginInfo.setLoginRoles(roles);

            if (StringUtil.isNotEmpty(userInfo.getLegalPersonality()) && !roles.contains(PermissionConstant.ROLE_ADMIN)) {
                loginInfo.setLegalPersonality(userInfo.getLegalPersonality());
            }

            return loginInfo;
        } else {
            throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "用户不存在或密码错误");
        }
    }

    public LoginInfo getToken(String userNo, String password) {
        UserInfo userInfo = iUserStorage.getLegalProxy(null).get(userNo, password);
        if (userInfo != null) {
            return getToken(userInfo);
        } else {
            throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "用户[" + userNo + "]不存在或密码错误");
        }
    }

    public LoginInfo getToken(String userNo) {
        UserInfo userInfo = iUserStorage.getLegalProxy(null).get(userNo);
        if (userInfo != null) {
            return getToken(userInfo);
        } else {
            throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "用户[" + userNo + "]不存在");
        }
    }

}
