package com.help.plugins;

import com.help.constraint.IDicExtension;
import com.help.constraint.IHelpSystemComponent;
import com.help.domain.DicItem;
import com.help.constant.EmployeeType;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户类型字典扩展
 *
 * @author: YuBin-002726
 * @Date: 2019/4/23 10:10
 */
@Component
public class UserTypeDicExtension implements IDicExtension, IHelpSystemComponent {
    @Override
    public String getDicType() {
        return "USER_TYPE";
    }

    @Override
    public List<DicItem> list() {
        return Arrays.stream(EmployeeType.values()).map(p -> {
            DicItem item = new DicItem();
            item.setDicType(this.getDicType());
            item.setCode(p.name());
            item.setText(p.getName());
            return item;
        }).collect(Collectors.toList());
    }

    @Override
    public boolean cacheable() {
        return false;
    }

    @Override
    public String getName() {
        return "用户类型字典扩展服务(" + (cacheable() ? "缓存" : "实时") + ")";
    }
}
