package com.help.plugins;

import com.help.constraint.IDicExtension;
import com.help.constraint.IHelpSystemComponent;
import com.help.domain.DicItem;
import com.help.storage.IRoleStorage;
import com.help.storage.editable.IEditableRoleStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 角色字典扩展
 *
 * @author: YuBin-002726
 * @Date: 2019/1/28 9:06
 */
@Component
public class RoleDicExtension implements IDicExtension, IHelpSystemComponent {

    @Autowired(required = false)
    IRoleStorage iRoleStorage;

    @Override
    public String getDicType() {
        return "ROLE";
    }

    @Override
    public List<DicItem> list() {
        if (iRoleStorage != null) {
            return iRoleStorage.list().stream().map(p -> new DicItem(p.getRoleNo(), p.getRoleName(), getDicType())).collect(Collectors.toList());
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public boolean cacheable() {
        return !(iRoleStorage instanceof IEditableRoleStorage);
    }

    @Override
    public String getName() {
        return "角色字典扩展服务(" + (cacheable() ? "缓存" : "实时") + ")";
    }
}
