package com.help.plugins;

import com.help.constant.OperationType;
import com.help.constraint.IDicExtension;
import com.help.domain.DicItem;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: YuBin-002726
 * @Date: 2019/9/29 9:03
 */
@Component
public class OperationTypeDicExtension implements IDicExtension {
    @Override
    public String getDicType() {
        return "OPERA_TYPE";
    }

    @Override
    public List<DicItem> list() {
        return Arrays.stream(OperationType.values()).map(p -> new DicItem(p.getCode(), p.getName(), getDicType())).collect(Collectors.toList());
    }

    @Override
    public boolean cacheable() {
        return false;
    }
}
