package com.help.plugins;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.constant.CacheConstant;
import com.help.constraint.IDicExtension;
import com.help.constraint.IHelpSystemComponent;
import com.help.domain.DicItem;
import com.help.storage.ILegalStorage;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: YuBin-002726
 * @Date: 2019/2/18 8:36
 */
@Component
public class LegalDicExtension implements IDicExtension, IHelpSystemComponent {

    @Autowired(required = false)
    ILegalStorage iLegalStorage;

    @Autowired(required = false)
    ITokenContext<LoginInfo> iTokenContext;

    @Autowired
    HelpManageConfig helpManageConfig;

    @Override
    public String getDicType() {
        return "LEGAL";
    }

    @Override
    public List<DicItem> list() {
        if (helpManageConfig.isMultiLegalEnable() && iTokenContext != null) {
            LoginInfo loginInfo = iTokenContext.getCurrentToken();
            if (loginInfo != null) {
                return ((LegalDicExtension) AopContext.currentProxy()).listByLegal(loginInfo.getLegalPersonality(), false);
            }
        }
        return ((LegalDicExtension) AopContext.currentProxy()).listByLegal(null, false);
    }

    @Cacheable(CacheConstant.CACHE_DICTIONARY)
    public List<DicItem> listByLegal(String legal, boolean limitIfEmpty) {
        if (iLegalStorage != null) {
            if ((StringUtil.isNotEmpty(legal) || limitIfEmpty)) {
                return iLegalStorage.getLegalProxy(legal).list().stream().filter(p -> p.getLegalNo().equals(legal)).map(p -> new DicItem(p.getLegalNo(), p.getLegalName(), getDicType())).collect(Collectors.toList());
            } else {
                return iLegalStorage.getLegalProxy(null).list().stream().map(p -> new DicItem(p.getLegalNo(), p.getLegalName(), getDicType())).collect(Collectors.toList());
            }
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public boolean cacheable() {
        //由自身实现缓存,不允许字典服务缓存
        return false;
    }

    @Override
    public String getName() {
        return "法人字典扩展服务(缓存)";
    }
}
