package com.help.plugins;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.constant.CacheConstant;
import com.help.constraint.IDicExtension;
import com.help.constraint.IHelpSystemComponent;
import com.help.domain.DicItem;
import com.help.storage.IDeptStorage;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 部门字典扩展
 *
 * @author: YuBin-002726
 * @Date: 2019/1/28 9:06
 */
@Component
public class DeptDicExtension implements IDicExtension, IHelpSystemComponent {

    @Autowired(required = false)
    IDeptStorage iDeptStorage;

    @Autowired
    HelpManageConfig helpManageConfig;

    @Override
    public String getDicType() {
        return "DEPT";
    }

    @Autowired(required = false)
    ITokenContext<LoginInfo> iTokenContext;

    @Override
    public List<DicItem> list() {
        if (helpManageConfig.isMultiLegalEnable() && iTokenContext != null) {
            LoginInfo loginInfo = iTokenContext.getCurrentToken();
            if (loginInfo != null) {
                return ((DeptDicExtension) AopContext.currentProxy()).listByLegal(loginInfo.getLegalPersonality(), false);
            }
        }
        return ((DeptDicExtension) AopContext.currentProxy()).listByLegal(null, false);
    }

    @Cacheable(CacheConstant.CACHE_DICTIONARY)
    public List<DicItem> listByLegal(String legal, boolean limitIfEmpty) {
        if (iDeptStorage != null) {
            if ((StringUtil.isNotEmpty(legal) || limitIfEmpty)) {
                return iDeptStorage.getLegalProxy(legal).list().stream().map(p -> new DicItem(p.getDeptNo(), p.getDeptName(), getDicType())).collect(Collectors.toList());
            } else {
                return iDeptStorage.getLegalProxy(null).list().stream().map(p -> new DicItem(p.getDeptNo(), p.getDeptName(), getDicType())).collect(Collectors.toList());
            }
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public boolean cacheable() {
        //由自身实现缓存,不允许字典服务缓存
        return false;
    }

    @Override
    public String getName() {
        return "部门字典扩展服务(缓存)";
    }
}
