package com.help.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.help.annotation.*;
import com.help.common.validate.*;
import com.help.constraint.IHelpDomain;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 对应数据库表 p_user_config
 *
 */
public class PUserConfig implements IHelpDomain {
    @Name("用户编号")
    @Length(max=20,dbmode=false)
    @Required
    private String userNo;

    @Name("配置项名称")
    @Length(max=50,dbmode=false)
    @Required
    private String name;

    @Name("配置项值")
    @Length(max=2000,dbmode=false)
    @Required
    private String value;

    public String getUserNo() {
        return userNo;
    }

    public PUserConfig withUserNo(String userNo) {
        this.setUserNo(userNo);
        return this;
    }

    public void setUserNo(String userNo) {
        this.userNo = userNo == null ? null : userNo.trim();
    }

    public String getName() {
        return name;
    }

    public PUserConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getValue() {
        return value;
    }

    public PUserConfig withValue(String value) {
        this.setValue(value);
        return this;
    }

    public void setValue(String value) {
        this.value = value == null ? null : value.trim();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", userNo=").append(userNo);
        sb.append(", name=").append(name);
        sb.append(", value=").append(value);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PUserConfig other = (PUserConfig) that;
        return (this.getUserNo() == null ? other.getUserNo() == null : this.getUserNo().equals(other.getUserNo()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getUserNo() == null) ? 0 : getUserNo().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getValue() == null) ? 0 : getValue().hashCode());
        return result;
    }
}