package com.help.domain;

import com.help.constraint.IHelpExample;
import java.util.ArrayList;
import java.util.List;

public class PRoleModuleOpExample implements IHelpExample<PRoleModuleOp, PRoleModuleOpExample.Criteria> {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    public PRoleModuleOpExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    @Override
    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    @Override
    public String getOrderByClause() {
        return orderByClause;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public boolean isDistinct() {
        return distinct;
    }

    @Override
    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    @Override
    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    @Override
    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    @Override
    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    @Override
    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    protected abstract static class AbstractGeneratedCriteria {
        protected List<Criterion> criteria;

        protected AbstractGeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andRoleNoIsNull() {
            addCriterion("role_no is null");
            return (Criteria) this;
        }

        public Criteria andRoleNoIsNotNull() {
            addCriterion("role_no is not null");
            return (Criteria) this;
        }

        public Criteria andRoleNoEqualTo(String value) {
            addCriterion("role_no =", value, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoNotEqualTo(String value) {
            addCriterion("role_no <>", value, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoGreaterThan(String value) {
            addCriterion("role_no >", value, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoGreaterThanOrEqualTo(String value) {
            addCriterion("role_no >=", value, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoLessThan(String value) {
            addCriterion("role_no <", value, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoLessThanOrEqualTo(String value) {
            addCriterion("role_no <=", value, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoLike(String value) {
            addCriterion("role_no like", value, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoNotLike(String value) {
            addCriterion("role_no not like", value, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoIn(List<String> values) {
            addCriterion("role_no in", values, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoNotIn(List<String> values) {
            addCriterion("role_no not in", values, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoBetween(String value1, String value2) {
            addCriterion("role_no between", value1, value2, "roleNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoNotBetween(String value1, String value2) {
            addCriterion("role_no not between", value1, value2, "roleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoIsNull() {
            addCriterion("module_no is null");
            return (Criteria) this;
        }

        public Criteria andModuleNoIsNotNull() {
            addCriterion("module_no is not null");
            return (Criteria) this;
        }

        public Criteria andModuleNoEqualTo(String value) {
            addCriterion("module_no =", value, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoNotEqualTo(String value) {
            addCriterion("module_no <>", value, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoGreaterThan(String value) {
            addCriterion("module_no >", value, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoGreaterThanOrEqualTo(String value) {
            addCriterion("module_no >=", value, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoLessThan(String value) {
            addCriterion("module_no <", value, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoLessThanOrEqualTo(String value) {
            addCriterion("module_no <=", value, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoLike(String value) {
            addCriterion("module_no like", value, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoNotLike(String value) {
            addCriterion("module_no not like", value, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoIn(List<String> values) {
            addCriterion("module_no in", values, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoNotIn(List<String> values) {
            addCriterion("module_no not in", values, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoBetween(String value1, String value2) {
            addCriterion("module_no between", value1, value2, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andModuleNoNotBetween(String value1, String value2) {
            addCriterion("module_no not between", value1, value2, "moduleNo");
            return (Criteria) this;
        }

        public Criteria andOpNoIsNull() {
            addCriterion("op_no is null");
            return (Criteria) this;
        }

        public Criteria andOpNoIsNotNull() {
            addCriterion("op_no is not null");
            return (Criteria) this;
        }

        public Criteria andOpNoEqualTo(String value) {
            addCriterion("op_no =", value, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoNotEqualTo(String value) {
            addCriterion("op_no <>", value, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoGreaterThan(String value) {
            addCriterion("op_no >", value, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoGreaterThanOrEqualTo(String value) {
            addCriterion("op_no >=", value, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoLessThan(String value) {
            addCriterion("op_no <", value, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoLessThanOrEqualTo(String value) {
            addCriterion("op_no <=", value, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoLike(String value) {
            addCriterion("op_no like", value, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoNotLike(String value) {
            addCriterion("op_no not like", value, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoIn(List<String> values) {
            addCriterion("op_no in", values, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoNotIn(List<String> values) {
            addCriterion("op_no not in", values, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoBetween(String value1, String value2) {
            addCriterion("op_no between", value1, value2, "opNo");
            return (Criteria) this;
        }

        public Criteria andOpNoNotBetween(String value1, String value2) {
            addCriterion("op_no not between", value1, value2, "opNo");
            return (Criteria) this;
        }

        public Criteria andRoleNoIsEmpty() {
            addCriterion("(role_no is null or role_no = '')");
            return (Criteria)this;
        }

        public Criteria andRoleNoNotEmpty() {
            addCriterion("(role_no is not null and role_no <> '')");
            return (Criteria)this;
        }

        public Criteria andModuleNoIsEmpty() {
            addCriterion("(module_no is null or module_no = '')");
            return (Criteria)this;
        }

        public Criteria andModuleNoNotEmpty() {
            addCriterion("(module_no is not null and module_no <> '')");
            return (Criteria)this;
        }

        public Criteria andOpNoIsEmpty() {
            addCriterion("(op_no is null or op_no = '')");
            return (Criteria)this;
        }

        public Criteria andOpNoNotEmpty() {
            addCriterion("(op_no is not null and op_no <> '')");
            return (Criteria)this;
        }
    }

    public static class Criteria extends AbstractGeneratedCriteria {

        protected Criteria() {
            super();
        }
    }

    public static class Criterion {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}