package com.help.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.help.annotation.*;
import com.help.common.validate.*;
import com.help.constraint.IHelpDomain;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 对应数据库表 p_role_module_op
 */
public class PRoleModuleOp implements IHelpDomain {
    @Name("角色号")
    @Length(max = 20, dbmode = false)
    @Required
    private String roleNo;

    @Name("模块编号")
    @Length(max = 60, dbmode = false)
    @Required
    private String moduleNo;

    @Name("功能编号")
    @Length(max = 100, dbmode = false)
    @Required
    private String opNo;

    public String getRoleNo() {
        return roleNo;
    }

    public PRoleModuleOp withRoleNo(String roleNo) {
        this.setRoleNo(roleNo);
        return this;
    }

    public void setRoleNo(String roleNo) {
        this.roleNo = roleNo == null ? null : roleNo.trim();
    }

    public String getModuleNo() {
        return moduleNo;
    }

    public PRoleModuleOp withModuleNo(String moduleNo) {
        this.setModuleNo(moduleNo);
        return this;
    }

    public void setModuleNo(String moduleNo) {
        this.moduleNo = moduleNo == null ? null : moduleNo.trim();
    }

    public String getOpNo() {
        return opNo;
    }

    public PRoleModuleOp withOpNo(String opNo) {
        this.setOpNo(opNo);
        return this;
    }

    public void setOpNo(String opNo) {
        this.opNo = opNo == null ? null : opNo.trim();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", roleNo=").append(roleNo);
        sb.append(", moduleNo=").append(moduleNo);
        sb.append(", opNo=").append(opNo);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PRoleModuleOp other = (PRoleModuleOp) that;
        return (this.getRoleNo() == null ? other.getRoleNo() == null : this.getRoleNo().equals(other.getRoleNo()))
                && (this.getModuleNo() == null ? other.getModuleNo() == null : this.getModuleNo().equals(other.getModuleNo()))
                && (this.getOpNo() == null ? other.getOpNo() == null : this.getOpNo().equals(other.getOpNo()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getRoleNo() == null) ? 0 : getRoleNo().hashCode());
        result = prime * result + ((getModuleNo() == null) ? 0 : getModuleNo().hashCode());
        result = prime * result + ((getOpNo() == null) ? 0 : getOpNo().hashCode());
        return result;
    }
}